/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAttachObject
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchAttachObject> {
    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchAttachObject.getter(BatchAttachObject::parentReference)).setter(BatchAttachObject.setter(Builder::parentReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()}).build();
    private static final SdkField<ObjectReference> CHILD_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchAttachObject.getter(BatchAttachObject::childReference)).setter(BatchAttachObject.setter(Builder::childReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChildReference").build()}).build();
    private static final SdkField<String> LINK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchAttachObject.getter(BatchAttachObject::linkName)).setter(BatchAttachObject.setter(Builder::linkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_REFERENCE_FIELD, CHILD_REFERENCE_FIELD, LINK_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final ObjectReference parentReference;
    private final ObjectReference childReference;
    private final String linkName;

    private BatchAttachObject(BuilderImpl builder) {
        this.parentReference = builder.parentReference;
        this.childReference = builder.childReference;
        this.linkName = builder.linkName;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public ObjectReference childReference() {
        return this.childReference;
    }

    public String linkName() {
        return this.linkName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.childReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachObject)) {
            return false;
        }
        BatchAttachObject other = (BatchAttachObject)obj;
        return Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.childReference(), other.childReference()) && Objects.equals(this.linkName(), other.linkName());
    }

    public String toString() {
        return ToString.builder((String)"BatchAttachObject").add("ParentReference", (Object)this.parentReference()).add("ChildReference", (Object)this.childReference()).add("LinkName", (Object)this.linkName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentReference": {
                return Optional.ofNullable(clazz.cast(this.parentReference()));
            }
            case "ChildReference": {
                return Optional.ofNullable(clazz.cast(this.childReference()));
            }
            case "LinkName": {
                return Optional.ofNullable(clazz.cast(this.linkName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAttachObject, T> g) {
        return obj -> g.apply((BatchAttachObject)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference parentReference;
        private ObjectReference childReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachObject model) {
            this.parentReference(model.parentReference);
            this.childReference(model.childReference);
            this.linkName(model.linkName);
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final ObjectReference.Builder getChildReference() {
            return this.childReference != null ? this.childReference.toBuilder() : null;
        }

        @Override
        public final Builder childReference(ObjectReference childReference) {
            this.childReference = childReference;
            return this;
        }

        public final void setChildReference(ObjectReference.BuilderImpl childReference) {
            this.childReference = childReference != null ? childReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        public BatchAttachObject build() {
            return new BatchAttachObject(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchAttachObject> {
        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(parentReference)).build());
        }

        public Builder childReference(ObjectReference var1);

        default public Builder childReference(Consumer<ObjectReference.Builder> childReference) {
            return this.childReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(childReference)).build());
        }

        public Builder linkName(String var1);
    }
}

