/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;

public class ListObjectAttributesPublisher
implements SdkPublisher<ListObjectAttributesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListObjectAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectAttributesPublisher(CloudDirectoryAsyncClient client, ListObjectAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectAttributesPublisher(CloudDirectoryAsyncClient client, ListObjectAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListObjectAttributesResponseFetcher
    implements AsyncPageFetcher<ListObjectAttributesResponse> {
        private ListObjectAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListObjectAttributesResponse> nextPage(ListObjectAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectAttributesPublisher.this.client.listObjectAttributes(ListObjectAttributesPublisher.this.firstRequest);
            }
            return ListObjectAttributesPublisher.this.client.listObjectAttributes((ListObjectAttributesRequest)((Object)ListObjectAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

