/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains all the information that is used to uniquely identify a typed link. The parameters discussed in this topic
 * are used to uniquely specify the typed link being operated on. The <a>AttachTypedLink</a> API returns a typed link
 * specifier while the <a>DetachTypedLink</a> API accepts one as input. Similarly, the <a>ListIncomingTypedLinks</a> and
 * <a>ListOutgoingTypedLinks</a> API operations provide typed link specifiers as output. You can also construct a typed
 * link specifier from scratch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TypedLinkSpecifier implements SdkPojo, Serializable,
        ToCopyableBuilder<TypedLinkSpecifier.Builder, TypedLinkSpecifier> {
    private static final SdkField<TypedLinkSchemaAndFacetName> TYPED_LINK_FACET_FIELD = SdkField
            .<TypedLinkSchemaAndFacetName> builder(MarshallingType.SDK_POJO).memberName("TypedLinkFacet")
            .getter(getter(TypedLinkSpecifier::typedLinkFacet)).setter(setter(Builder::typedLinkFacet))
            .constructor(TypedLinkSchemaAndFacetName::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkFacet").build()).build();

    private static final SdkField<ObjectReference> SOURCE_OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("SourceObjectReference")
            .getter(getter(TypedLinkSpecifier::sourceObjectReference)).setter(setter(Builder::sourceObjectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceObjectReference").build())
            .build();

    private static final SdkField<ObjectReference> TARGET_OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("TargetObjectReference")
            .getter(getter(TypedLinkSpecifier::targetObjectReference)).setter(setter(Builder::targetObjectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetObjectReference").build())
            .build();

    private static final SdkField<List<AttributeNameAndValue>> IDENTITY_ATTRIBUTE_VALUES_FIELD = SdkField
            .<List<AttributeNameAndValue>> builder(MarshallingType.LIST)
            .memberName("IdentityAttributeValues")
            .getter(getter(TypedLinkSpecifier::identityAttributeValues))
            .setter(setter(Builder::identityAttributeValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttributeNameAndValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttributeNameAndValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPED_LINK_FACET_FIELD,
            SOURCE_OBJECT_REFERENCE_FIELD, TARGET_OBJECT_REFERENCE_FIELD, IDENTITY_ATTRIBUTE_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TypedLinkSchemaAndFacetName typedLinkFacet;

    private final ObjectReference sourceObjectReference;

    private final ObjectReference targetObjectReference;

    private final List<AttributeNameAndValue> identityAttributeValues;

    private TypedLinkSpecifier(BuilderImpl builder) {
        this.typedLinkFacet = builder.typedLinkFacet;
        this.sourceObjectReference = builder.sourceObjectReference;
        this.targetObjectReference = builder.targetObjectReference;
        this.identityAttributeValues = builder.identityAttributeValues;
    }

    /**
     * <p>
     * Identifies the typed link facet that is associated with the typed link.
     * </p>
     * 
     * @return Identifies the typed link facet that is associated with the typed link.
     */
    public final TypedLinkSchemaAndFacetName typedLinkFacet() {
        return typedLinkFacet;
    }

    /**
     * <p>
     * Identifies the source object that the typed link will attach to.
     * </p>
     * 
     * @return Identifies the source object that the typed link will attach to.
     */
    public final ObjectReference sourceObjectReference() {
        return sourceObjectReference;
    }

    /**
     * <p>
     * Identifies the target object that the typed link will attach to.
     * </p>
     * 
     * @return Identifies the target object that the typed link will attach to.
     */
    public final ObjectReference targetObjectReference() {
        return targetObjectReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityAttributeValues property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityAttributeValues() {
        return identityAttributeValues != null && !(identityAttributeValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the attribute value to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityAttributeValues} method.
     * </p>
     * 
     * @return Identifies the attribute value to update.
     */
    public final List<AttributeNameAndValue> identityAttributeValues() {
        return identityAttributeValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typedLinkFacet());
        hashCode = 31 * hashCode + Objects.hashCode(sourceObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(targetObjectReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityAttributeValues() ? identityAttributeValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkSpecifier)) {
            return false;
        }
        TypedLinkSpecifier other = (TypedLinkSpecifier) obj;
        return Objects.equals(typedLinkFacet(), other.typedLinkFacet())
                && Objects.equals(sourceObjectReference(), other.sourceObjectReference())
                && Objects.equals(targetObjectReference(), other.targetObjectReference())
                && hasIdentityAttributeValues() == other.hasIdentityAttributeValues()
                && Objects.equals(identityAttributeValues(), other.identityAttributeValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TypedLinkSpecifier").add("TypedLinkFacet", typedLinkFacet())
                .add("SourceObjectReference", sourceObjectReference()).add("TargetObjectReference", targetObjectReference())
                .add("IdentityAttributeValues", hasIdentityAttributeValues() ? identityAttributeValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypedLinkFacet":
            return Optional.ofNullable(clazz.cast(typedLinkFacet()));
        case "SourceObjectReference":
            return Optional.ofNullable(clazz.cast(sourceObjectReference()));
        case "TargetObjectReference":
            return Optional.ofNullable(clazz.cast(targetObjectReference()));
        case "IdentityAttributeValues":
            return Optional.ofNullable(clazz.cast(identityAttributeValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TypedLinkFacet", TYPED_LINK_FACET_FIELD);
        map.put("SourceObjectReference", SOURCE_OBJECT_REFERENCE_FIELD);
        map.put("TargetObjectReference", TARGET_OBJECT_REFERENCE_FIELD);
        map.put("IdentityAttributeValues", IDENTITY_ATTRIBUTE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TypedLinkSpecifier, T> g) {
        return obj -> g.apply((TypedLinkSpecifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TypedLinkSpecifier> {
        /**
         * <p>
         * Identifies the typed link facet that is associated with the typed link.
         * </p>
         * 
         * @param typedLinkFacet
         *        Identifies the typed link facet that is associated with the typed link.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet);

        /**
         * <p>
         * Identifies the typed link facet that is associated with the typed link.
         * </p>
         * This is a convenience method that creates an instance of the {@link TypedLinkSchemaAndFacetName.Builder}
         * avoiding the need to create one manually via {@link TypedLinkSchemaAndFacetName#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TypedLinkSchemaAndFacetName.Builder#build()} is called
         * immediately and its result is passed to {@link #typedLinkFacet(TypedLinkSchemaAndFacetName)}.
         * 
         * @param typedLinkFacet
         *        a consumer that will call methods on {@link TypedLinkSchemaAndFacetName.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #typedLinkFacet(TypedLinkSchemaAndFacetName)
         */
        default Builder typedLinkFacet(Consumer<TypedLinkSchemaAndFacetName.Builder> typedLinkFacet) {
            return typedLinkFacet(TypedLinkSchemaAndFacetName.builder().applyMutation(typedLinkFacet).build());
        }

        /**
         * <p>
         * Identifies the source object that the typed link will attach to.
         * </p>
         * 
         * @param sourceObjectReference
         *        Identifies the source object that the typed link will attach to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceObjectReference(ObjectReference sourceObjectReference);

        /**
         * <p>
         * Identifies the source object that the typed link will attach to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceObjectReference(ObjectReference)}.
         * 
         * @param sourceObjectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceObjectReference(ObjectReference)
         */
        default Builder sourceObjectReference(Consumer<ObjectReference.Builder> sourceObjectReference) {
            return sourceObjectReference(ObjectReference.builder().applyMutation(sourceObjectReference).build());
        }

        /**
         * <p>
         * Identifies the target object that the typed link will attach to.
         * </p>
         * 
         * @param targetObjectReference
         *        Identifies the target object that the typed link will attach to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetObjectReference(ObjectReference targetObjectReference);

        /**
         * <p>
         * Identifies the target object that the typed link will attach to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #targetObjectReference(ObjectReference)}.
         * 
         * @param targetObjectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetObjectReference(ObjectReference)
         */
        default Builder targetObjectReference(Consumer<ObjectReference.Builder> targetObjectReference) {
            return targetObjectReference(ObjectReference.builder().applyMutation(targetObjectReference).build());
        }

        /**
         * <p>
         * Identifies the attribute value to update.
         * </p>
         * 
         * @param identityAttributeValues
         *        Identifies the attribute value to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeValues(Collection<AttributeNameAndValue> identityAttributeValues);

        /**
         * <p>
         * Identifies the attribute value to update.
         * </p>
         * 
         * @param identityAttributeValues
         *        Identifies the attribute value to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityAttributeValues(AttributeNameAndValue... identityAttributeValues);

        /**
         * <p>
         * Identifies the attribute value to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue.Builder#build()} is called
         * immediately and its result is passed to {@link #identityAttributeValues(List<AttributeNameAndValue>)}.
         * 
         * @param identityAttributeValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.clouddirectory.model.AttributeNameAndValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityAttributeValues(java.util.Collection<AttributeNameAndValue>)
         */
        Builder identityAttributeValues(Consumer<AttributeNameAndValue.Builder>... identityAttributeValues);
    }

    static final class BuilderImpl implements Builder {
        private TypedLinkSchemaAndFacetName typedLinkFacet;

        private ObjectReference sourceObjectReference;

        private ObjectReference targetObjectReference;

        private List<AttributeNameAndValue> identityAttributeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkSpecifier model) {
            typedLinkFacet(model.typedLinkFacet);
            sourceObjectReference(model.sourceObjectReference);
            targetObjectReference(model.targetObjectReference);
            identityAttributeValues(model.identityAttributeValues);
        }

        public final TypedLinkSchemaAndFacetName.Builder getTypedLinkFacet() {
            return typedLinkFacet != null ? typedLinkFacet.toBuilder() : null;
        }

        public final void setTypedLinkFacet(TypedLinkSchemaAndFacetName.BuilderImpl typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet != null ? typedLinkFacet.build() : null;
        }

        @Override
        public final Builder typedLinkFacet(TypedLinkSchemaAndFacetName typedLinkFacet) {
            this.typedLinkFacet = typedLinkFacet;
            return this;
        }

        public final ObjectReference.Builder getSourceObjectReference() {
            return sourceObjectReference != null ? sourceObjectReference.toBuilder() : null;
        }

        public final void setSourceObjectReference(ObjectReference.BuilderImpl sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference != null ? sourceObjectReference.build() : null;
        }

        @Override
        public final Builder sourceObjectReference(ObjectReference sourceObjectReference) {
            this.sourceObjectReference = sourceObjectReference;
            return this;
        }

        public final ObjectReference.Builder getTargetObjectReference() {
            return targetObjectReference != null ? targetObjectReference.toBuilder() : null;
        }

        public final void setTargetObjectReference(ObjectReference.BuilderImpl targetObjectReference) {
            this.targetObjectReference = targetObjectReference != null ? targetObjectReference.build() : null;
        }

        @Override
        public final Builder targetObjectReference(ObjectReference targetObjectReference) {
            this.targetObjectReference = targetObjectReference;
            return this;
        }

        public final List<AttributeNameAndValue.Builder> getIdentityAttributeValues() {
            List<AttributeNameAndValue.Builder> result = AttributeNameAndValueListCopier
                    .copyToBuilder(this.identityAttributeValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityAttributeValues(Collection<AttributeNameAndValue.BuilderImpl> identityAttributeValues) {
            this.identityAttributeValues = AttributeNameAndValueListCopier.copyFromBuilder(identityAttributeValues);
        }

        @Override
        public final Builder identityAttributeValues(Collection<AttributeNameAndValue> identityAttributeValues) {
            this.identityAttributeValues = AttributeNameAndValueListCopier.copy(identityAttributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeValues(AttributeNameAndValue... identityAttributeValues) {
            identityAttributeValues(Arrays.asList(identityAttributeValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeValues(Consumer<AttributeNameAndValue.Builder>... identityAttributeValues) {
            identityAttributeValues(Stream.of(identityAttributeValues)
                    .map(c -> AttributeNameAndValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TypedLinkSpecifier build() {
            return new TypedLinkSpecifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
