/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attaches a policy object to a regular object inside a <a>BatchRead</a> operation. For more information, see
 * <a>AttachPolicy</a> and <a>BatchReadRequest$Operations</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAttachPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchAttachPolicy.Builder, BatchAttachPolicy> {
    private static final SdkField<ObjectReference> POLICY_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("PolicyReference")
            .getter(getter(BatchAttachPolicy::policyReference)).setter(setter(Builder::policyReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReference").build()).build();

    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField
            .<ObjectReference> builder(MarshallingType.SDK_POJO).memberName("ObjectReference")
            .getter(getter(BatchAttachPolicy::objectReference)).setter(setter(Builder::objectReference))
            .constructor(ObjectReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_REFERENCE_FIELD,
            OBJECT_REFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ObjectReference policyReference;

    private final ObjectReference objectReference;

    private BatchAttachPolicy(BuilderImpl builder) {
        this.policyReference = builder.policyReference;
        this.objectReference = builder.objectReference;
    }

    /**
     * <p>
     * The reference that is associated with the policy object.
     * </p>
     * 
     * @return The reference that is associated with the policy object.
     */
    public final ObjectReference policyReference() {
        return policyReference;
    }

    /**
     * <p>
     * The reference that identifies the object to which the policy will be attached.
     * </p>
     * 
     * @return The reference that identifies the object to which the policy will be attached.
     */
    public final ObjectReference objectReference() {
        return objectReference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyReference());
        hashCode = 31 * hashCode + Objects.hashCode(objectReference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAttachPolicy)) {
            return false;
        }
        BatchAttachPolicy other = (BatchAttachPolicy) obj;
        return Objects.equals(policyReference(), other.policyReference())
                && Objects.equals(objectReference(), other.objectReference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchAttachPolicy").add("PolicyReference", policyReference())
                .add("ObjectReference", objectReference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyReference":
            return Optional.ofNullable(clazz.cast(policyReference()));
        case "ObjectReference":
            return Optional.ofNullable(clazz.cast(objectReference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyReference", POLICY_REFERENCE_FIELD);
        map.put("ObjectReference", OBJECT_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAttachPolicy, T> g) {
        return obj -> g.apply((BatchAttachPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchAttachPolicy> {
        /**
         * <p>
         * The reference that is associated with the policy object.
         * </p>
         * 
         * @param policyReference
         *        The reference that is associated with the policy object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyReference(ObjectReference policyReference);

        /**
         * <p>
         * The reference that is associated with the policy object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #policyReference(ObjectReference)}.
         * 
         * @param policyReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyReference(ObjectReference)
         */
        default Builder policyReference(Consumer<ObjectReference.Builder> policyReference) {
            return policyReference(ObjectReference.builder().applyMutation(policyReference).build());
        }

        /**
         * <p>
         * The reference that identifies the object to which the policy will be attached.
         * </p>
         * 
         * @param objectReference
         *        The reference that identifies the object to which the policy will be attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectReference(ObjectReference objectReference);

        /**
         * <p>
         * The reference that identifies the object to which the policy will be attached.
         * </p>
         * This is a convenience method that creates an instance of the {@link ObjectReference.Builder} avoiding the
         * need to create one manually via {@link ObjectReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ObjectReference.Builder#build()} is called immediately and its
         * result is passed to {@link #objectReference(ObjectReference)}.
         * 
         * @param objectReference
         *        a consumer that will call methods on {@link ObjectReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectReference(ObjectReference)
         */
        default Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return objectReference(ObjectReference.builder().applyMutation(objectReference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ObjectReference policyReference;

        private ObjectReference objectReference;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAttachPolicy model) {
            policyReference(model.policyReference);
            objectReference(model.objectReference);
        }

        public final ObjectReference.Builder getPolicyReference() {
            return policyReference != null ? policyReference.toBuilder() : null;
        }

        public final void setPolicyReference(ObjectReference.BuilderImpl policyReference) {
            this.policyReference = policyReference != null ? policyReference.build() : null;
        }

        @Override
        public final Builder policyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
            return this;
        }

        public final ObjectReference.Builder getObjectReference() {
            return objectReference != null ? objectReference.toBuilder() : null;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        @Override
        public BatchAttachPolicy build() {
            return new BatchAttachPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
