/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTypedLinkFacetInformationResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, GetTypedLinkFacetInformationResponse> {
    private static final SdkField<List<String>> IDENTITY_ATTRIBUTE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IdentityAttributeOrder").getter(GetTypedLinkFacetInformationResponse.getter(GetTypedLinkFacetInformationResponse::identityAttributeOrder)).setter(GetTypedLinkFacetInformationResponse.setter(Builder::identityAttributeOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_ATTRIBUTE_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTypedLinkFacetInformationResponse.memberNameToFieldInitializer();
    private final List<String> identityAttributeOrder;

    private GetTypedLinkFacetInformationResponse(BuilderImpl builder) {
        super(builder);
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    public final boolean hasIdentityAttributeOrder() {
        return this.identityAttributeOrder != null && !(this.identityAttributeOrder instanceof SdkAutoConstructList);
    }

    public final List<String> identityAttributeOrder() {
        return this.identityAttributeOrder;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityAttributeOrder() ? this.identityAttributeOrder() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTypedLinkFacetInformationResponse)) {
            return false;
        }
        GetTypedLinkFacetInformationResponse other = (GetTypedLinkFacetInformationResponse)((Object)obj);
        return this.hasIdentityAttributeOrder() == other.hasIdentityAttributeOrder() && Objects.equals(this.identityAttributeOrder(), other.identityAttributeOrder());
    }

    public final String toString() {
        return ToString.builder((String)"GetTypedLinkFacetInformationResponse").add("IdentityAttributeOrder", this.hasIdentityAttributeOrder() ? this.identityAttributeOrder() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdentityAttributeOrder": {
                return Optional.ofNullable(clazz.cast(this.identityAttributeOrder()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("IdentityAttributeOrder", IDENTITY_ATTRIBUTE_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTypedLinkFacetInformationResponse, T> g) {
        return obj -> g.apply((GetTypedLinkFacetInformationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<String> identityAttributeOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTypedLinkFacetInformationResponse model) {
            super(model);
            this.identityAttributeOrder(model.identityAttributeOrder);
        }

        public final Collection<String> getIdentityAttributeOrder() {
            if (this.identityAttributeOrder instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identityAttributeOrder;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String ... identityAttributeOrder) {
            this.identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        @Override
        public GetTypedLinkFacetInformationResponse build() {
            return new GetTypedLinkFacetInformationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTypedLinkFacetInformationResponse> {
        public Builder identityAttributeOrder(Collection<String> var1);

        public Builder identityAttributeOrder(String ... var1);
    }
}

