/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiers;
import software.amazon.awssdk.services.clouddirectory.model.PathToObjectIdentifiersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListObjectParentPathsResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListObjectParentPathsResponse> {
    private static final SdkField<List<PathToObjectIdentifiers>> PATH_TO_OBJECT_IDENTIFIERS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PathToObjectIdentifiersList").getter(ListObjectParentPathsResponse.getter(ListObjectParentPathsResponse::pathToObjectIdentifiersList)).setter(ListObjectParentPathsResponse.setter(Builder::pathToObjectIdentifiersList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathToObjectIdentifiersList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PathToObjectIdentifiers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListObjectParentPathsResponse.getter(ListObjectParentPathsResponse::nextToken)).setter(ListObjectParentPathsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_TO_OBJECT_IDENTIFIERS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListObjectParentPathsResponse.memberNameToFieldInitializer();
    private final List<PathToObjectIdentifiers> pathToObjectIdentifiersList;
    private final String nextToken;

    private ListObjectParentPathsResponse(BuilderImpl builder) {
        super(builder);
        this.pathToObjectIdentifiersList = builder.pathToObjectIdentifiersList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPathToObjectIdentifiersList() {
        return this.pathToObjectIdentifiersList != null && !(this.pathToObjectIdentifiersList instanceof SdkAutoConstructList);
    }

    public final List<PathToObjectIdentifiers> pathToObjectIdentifiersList() {
        return this.pathToObjectIdentifiersList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPathToObjectIdentifiersList() ? this.pathToObjectIdentifiersList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListObjectParentPathsResponse)) {
            return false;
        }
        ListObjectParentPathsResponse other = (ListObjectParentPathsResponse)((Object)obj);
        return this.hasPathToObjectIdentifiersList() == other.hasPathToObjectIdentifiersList() && Objects.equals(this.pathToObjectIdentifiersList(), other.pathToObjectIdentifiersList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListObjectParentPathsResponse").add("PathToObjectIdentifiersList", this.hasPathToObjectIdentifiersList() ? this.pathToObjectIdentifiersList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PathToObjectIdentifiersList": {
                return Optional.ofNullable(clazz.cast(this.pathToObjectIdentifiersList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PathToObjectIdentifiersList", PATH_TO_OBJECT_IDENTIFIERS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListObjectParentPathsResponse, T> g) {
        return obj -> g.apply((ListObjectParentPathsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<PathToObjectIdentifiers> pathToObjectIdentifiersList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListObjectParentPathsResponse model) {
            super(model);
            this.pathToObjectIdentifiersList(model.pathToObjectIdentifiersList);
            this.nextToken(model.nextToken);
        }

        public final List<PathToObjectIdentifiers.Builder> getPathToObjectIdentifiersList() {
            List<PathToObjectIdentifiers.Builder> result = PathToObjectIdentifiersListCopier.copyToBuilder(this.pathToObjectIdentifiersList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPathToObjectIdentifiersList(Collection<PathToObjectIdentifiers.BuilderImpl> pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList = PathToObjectIdentifiersListCopier.copyFromBuilder(pathToObjectIdentifiersList);
        }

        @Override
        public final Builder pathToObjectIdentifiersList(Collection<PathToObjectIdentifiers> pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList = PathToObjectIdentifiersListCopier.copy(pathToObjectIdentifiersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathToObjectIdentifiersList(PathToObjectIdentifiers ... pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList(Arrays.asList(pathToObjectIdentifiersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pathToObjectIdentifiersList(Consumer<PathToObjectIdentifiers.Builder> ... pathToObjectIdentifiersList) {
            this.pathToObjectIdentifiersList(Stream.of(pathToObjectIdentifiersList).map(c -> (PathToObjectIdentifiers)((PathToObjectIdentifiers.Builder)PathToObjectIdentifiers.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListObjectParentPathsResponse build() {
            return new ListObjectParentPathsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListObjectParentPathsResponse> {
        public Builder pathToObjectIdentifiersList(Collection<PathToObjectIdentifiers> var1);

        public Builder pathToObjectIdentifiersList(PathToObjectIdentifiers ... var1);

        public Builder pathToObjectIdentifiersList(Consumer<PathToObjectIdentifiers.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

