/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypedAttributeValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypedAttributeValue> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StringValue").getter(TypedAttributeValue.getter(TypedAttributeValue::stringValue)).setter(TypedAttributeValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()}).build();
    private static final SdkField<SdkBytes> BINARY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("BinaryValue").getter(TypedAttributeValue.getter(TypedAttributeValue::binaryValue)).setter(TypedAttributeValue.setter(Builder::binaryValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BinaryValue").build()}).build();
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BooleanValue").getter(TypedAttributeValue.getter(TypedAttributeValue::booleanValue)).setter(TypedAttributeValue.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanValue").build()}).build();
    private static final SdkField<String> NUMBER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NumberValue").getter(TypedAttributeValue.getter(TypedAttributeValue::numberValue)).setter(TypedAttributeValue.setter(Builder::numberValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberValue").build()}).build();
    private static final SdkField<Instant> DATETIME_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DatetimeValue").getter(TypedAttributeValue.getter(TypedAttributeValue::datetimeValue)).setter(TypedAttributeValue.setter(Builder::datetimeValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatetimeValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD, BINARY_VALUE_FIELD, BOOLEAN_VALUE_FIELD, NUMBER_VALUE_FIELD, DATETIME_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TypedAttributeValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final SdkBytes binaryValue;
    private final Boolean booleanValue;
    private final String numberValue;
    private final Instant datetimeValue;
    private final Type type;

    private TypedAttributeValue(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.binaryValue = builder.binaryValue;
        this.booleanValue = builder.booleanValue;
        this.numberValue = builder.numberValue;
        this.datetimeValue = builder.datetimeValue;
        this.type = builder.type;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final SdkBytes binaryValue() {
        return this.binaryValue;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final String numberValue() {
        return this.numberValue;
    }

    public final Instant datetimeValue() {
        return this.datetimeValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.binaryValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.datetimeValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedAttributeValue)) {
            return false;
        }
        TypedAttributeValue other = (TypedAttributeValue)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.binaryValue(), other.binaryValue()) && Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.numberValue(), other.numberValue()) && Objects.equals(this.datetimeValue(), other.datetimeValue());
    }

    public final String toString() {
        return ToString.builder((String)"TypedAttributeValue").add("StringValue", (Object)this.stringValue()).add("BinaryValue", (Object)this.binaryValue()).add("BooleanValue", (Object)this.booleanValue()).add("NumberValue", (Object)this.numberValue()).add("DatetimeValue", (Object)this.datetimeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "BinaryValue": {
                return Optional.ofNullable(clazz.cast(this.binaryValue()));
            }
            case "BooleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "NumberValue": {
                return Optional.ofNullable(clazz.cast(this.numberValue()));
            }
            case "DatetimeValue": {
                return Optional.ofNullable(clazz.cast(this.datetimeValue()));
            }
        }
        return Optional.empty();
    }

    public static TypedAttributeValue fromStringValue(String stringValue) {
        return (TypedAttributeValue)TypedAttributeValue.builder().stringValue(stringValue).build();
    }

    public static TypedAttributeValue fromBinaryValue(SdkBytes binaryValue) {
        return (TypedAttributeValue)TypedAttributeValue.builder().binaryValue(binaryValue).build();
    }

    public static TypedAttributeValue fromBooleanValue(Boolean booleanValue) {
        return (TypedAttributeValue)TypedAttributeValue.builder().booleanValue(booleanValue).build();
    }

    public static TypedAttributeValue fromNumberValue(String numberValue) {
        return (TypedAttributeValue)TypedAttributeValue.builder().numberValue(numberValue).build();
    }

    public static TypedAttributeValue fromDatetimeValue(Instant datetimeValue) {
        return (TypedAttributeValue)TypedAttributeValue.builder().datetimeValue(datetimeValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringValue", STRING_VALUE_FIELD);
        map.put("BinaryValue", BINARY_VALUE_FIELD);
        map.put("BooleanValue", BOOLEAN_VALUE_FIELD);
        map.put("NumberValue", NUMBER_VALUE_FIELD);
        map.put("DatetimeValue", DATETIME_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TypedAttributeValue, T> g) {
        return obj -> g.apply((TypedAttributeValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STRING_VALUE,
        BINARY_VALUE,
        BOOLEAN_VALUE,
        NUMBER_VALUE,
        DATETIME_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private SdkBytes binaryValue;
        private Boolean booleanValue;
        private String numberValue;
        private Instant datetimeValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TypedAttributeValue model) {
            this.stringValue(model.stringValue);
            this.binaryValue(model.binaryValue);
            this.booleanValue(model.booleanValue);
            this.numberValue(model.numberValue);
            this.datetimeValue(model.datetimeValue);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final ByteBuffer getBinaryValue() {
            return this.binaryValue == null ? null : this.binaryValue.asByteBuffer();
        }

        public final void setBinaryValue(ByteBuffer binaryValue) {
            this.binaryValue(binaryValue == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)binaryValue));
        }

        @Override
        public final Builder binaryValue(SdkBytes binaryValue) {
            SdkBytes oldValue = this.binaryValue;
            this.binaryValue = binaryValue;
            this.handleUnionValueChange(Type.BINARY_VALUE, oldValue, this.binaryValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final String getNumberValue() {
            return this.numberValue;
        }

        public final void setNumberValue(String numberValue) {
            String oldValue = this.numberValue;
            this.numberValue = numberValue;
            this.handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
        }

        @Override
        public final Builder numberValue(String numberValue) {
            String oldValue = this.numberValue;
            this.numberValue = numberValue;
            this.handleUnionValueChange(Type.NUMBER_VALUE, oldValue, this.numberValue);
            return this;
        }

        public final Instant getDatetimeValue() {
            return this.datetimeValue;
        }

        public final void setDatetimeValue(Instant datetimeValue) {
            Instant oldValue = this.datetimeValue;
            this.datetimeValue = datetimeValue;
            this.handleUnionValueChange(Type.DATETIME_VALUE, oldValue, this.datetimeValue);
        }

        @Override
        public final Builder datetimeValue(Instant datetimeValue) {
            Instant oldValue = this.datetimeValue;
            this.datetimeValue = datetimeValue;
            this.handleUnionValueChange(Type.DATETIME_VALUE, oldValue, this.datetimeValue);
            return this;
        }

        public TypedAttributeValue build() {
            return new TypedAttributeValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypedAttributeValue> {
        public Builder stringValue(String var1);

        public Builder binaryValue(SdkBytes var1);

        public Builder booleanValue(Boolean var1);

        public Builder numberValue(String var1);

        public Builder datetimeValue(Instant var1);
    }
}

