/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse;

public class ListTagsForResourceIterable
implements SdkIterable<ListTagsForResourceResponse> {
    private final CloudDirectoryClient client;
    private final ListTagsForResourceRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsForResourceIterable(CloudDirectoryClient client, ListTagsForResourceRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTagsForResourceResponseFetcher();
    }

    public Iterator<ListTagsForResourceResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListTagsForResourceIterable resume(ListTagsForResourceResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListTagsForResourceIterable(this.client, (ListTagsForResourceRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListTagsForResourceIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListTagsForResourceResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListTagsForResourceResponseFetcher
    implements SyncPageFetcher<ListTagsForResourceResponse> {
        private ListTagsForResourceResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsForResourceResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTagsForResourceResponse nextPage(ListTagsForResourceResponse previousPage) {
            if (previousPage == null) {
                return ListTagsForResourceIterable.this.client.listTagsForResource(ListTagsForResourceIterable.this.firstRequest);
            }
            return ListTagsForResourceIterable.this.client.listTagsForResource((ListTagsForResourceRequest)((Object)ListTagsForResourceIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

