/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.clouddirectory.model.LinkNameToObjectIdentifierMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListObjectChildrenResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListObjectChildrenResponse> {
    private static final SdkField<Map<String, String>> CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(BatchListObjectChildrenResponse.getter(BatchListObjectChildrenResponse::children)).setter(BatchListObjectChildrenResponse.setter(Builder::children)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Children").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchListObjectChildrenResponse.getter(BatchListObjectChildrenResponse::nextToken)).setter(BatchListObjectChildrenResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHILDREN_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> children;
    private final String nextToken;

    private BatchListObjectChildrenResponse(BuilderImpl builder) {
        this.children = builder.children;
        this.nextToken = builder.nextToken;
    }

    public Map<String, String> children() {
        return this.children;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.children());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectChildrenResponse)) {
            return false;
        }
        BatchListObjectChildrenResponse other = (BatchListObjectChildrenResponse)obj;
        return Objects.equals(this.children(), other.children()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"BatchListObjectChildrenResponse").add("Children", this.children()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Children": {
                return Optional.ofNullable(clazz.cast(this.children()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListObjectChildrenResponse, T> g) {
        return obj -> g.apply((BatchListObjectChildrenResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> children = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectChildrenResponse model) {
            this.children(model.children);
            this.nextToken(model.nextToken);
        }

        public final Map<String, String> getChildren() {
            return this.children;
        }

        @Override
        public final Builder children(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
            return this;
        }

        public final void setChildren(Map<String, String> children) {
            this.children = LinkNameToObjectIdentifierMapCopier.copy(children);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchListObjectChildrenResponse build() {
            return new BatchListObjectChildrenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListObjectChildrenResponse> {
        public Builder children(Map<String, String> var1);

        public Builder nextToken(String var1);
    }
}

