/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse;

public class ListFacetNamesPublisher
implements SdkPublisher<ListFacetNamesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListFacetNamesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFacetNamesPublisher(CloudDirectoryAsyncClient client, ListFacetNamesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFacetNamesPublisher(CloudDirectoryAsyncClient client, ListFacetNamesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFacetNamesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFacetNamesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListFacetNamesPublisher resume(ListFacetNamesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFacetNamesPublisher(this.client, (ListFacetNamesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListFacetNamesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListFacetNamesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListFacetNamesResponseFetcher
    implements AsyncPageFetcher<ListFacetNamesResponse> {
        private ListFacetNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListFacetNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFacetNamesResponse> nextPage(ListFacetNamesResponse previousPage) {
            if (previousPage == null) {
                return ListFacetNamesPublisher.this.client.listFacetNames(ListFacetNamesPublisher.this.firstRequest);
            }
            return ListFacetNamesPublisher.this.client.listFacetNames((ListFacetNamesRequest)((Object)ListFacetNamesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

