/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameTuple;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListObjectParentsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListObjectParentsResponse> {
    private static final SdkField<List<ObjectIdentifierAndLinkNameTuple>> PARENT_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParentLinks").getter(BatchListObjectParentsResponse.getter(BatchListObjectParentsResponse::parentLinks)).setter(BatchListObjectParentsResponse.setter(Builder::parentLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectIdentifierAndLinkNameTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchListObjectParentsResponse.getter(BatchListObjectParentsResponse::nextToken)).setter(BatchListObjectParentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_LINKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ParentLinks", PARENT_LINKS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ObjectIdentifierAndLinkNameTuple> parentLinks;
    private final String nextToken;

    private BatchListObjectParentsResponse(BuilderImpl builder) {
        this.parentLinks = builder.parentLinks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasParentLinks() {
        return this.parentLinks != null && !(this.parentLinks instanceof SdkAutoConstructList);
    }

    public final List<ObjectIdentifierAndLinkNameTuple> parentLinks() {
        return this.parentLinks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParentLinks() ? this.parentLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListObjectParentsResponse)) {
            return false;
        }
        BatchListObjectParentsResponse other = (BatchListObjectParentsResponse)obj;
        return this.hasParentLinks() == other.hasParentLinks() && Objects.equals(this.parentLinks(), other.parentLinks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchListObjectParentsResponse").add("ParentLinks", this.hasParentLinks() ? this.parentLinks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParentLinks": {
                return Optional.ofNullable(clazz.cast(this.parentLinks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchListObjectParentsResponse, T> g) {
        return obj -> g.apply((BatchListObjectParentsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ObjectIdentifierAndLinkNameTuple> parentLinks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListObjectParentsResponse model) {
            this.parentLinks(model.parentLinks);
            this.nextToken(model.nextToken);
        }

        public final List<ObjectIdentifierAndLinkNameTuple.Builder> getParentLinks() {
            List<ObjectIdentifierAndLinkNameTuple.Builder> result = ObjectIdentifierAndLinkNameListCopier.copyToBuilder(this.parentLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParentLinks(Collection<ObjectIdentifierAndLinkNameTuple.BuilderImpl> parentLinks) {
            this.parentLinks = ObjectIdentifierAndLinkNameListCopier.copyFromBuilder(parentLinks);
        }

        @Override
        public final Builder parentLinks(Collection<ObjectIdentifierAndLinkNameTuple> parentLinks) {
            this.parentLinks = ObjectIdentifierAndLinkNameListCopier.copy(parentLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentLinks(ObjectIdentifierAndLinkNameTuple ... parentLinks) {
            this.parentLinks(Arrays.asList(parentLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentLinks(Consumer<ObjectIdentifierAndLinkNameTuple.Builder> ... parentLinks) {
            this.parentLinks(Stream.of(parentLinks).map(c -> (ObjectIdentifierAndLinkNameTuple)((ObjectIdentifierAndLinkNameTuple.Builder)ObjectIdentifierAndLinkNameTuple.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public BatchListObjectParentsResponse build() {
            return new BatchListObjectParentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListObjectParentsResponse> {
        public Builder parentLinks(Collection<ObjectIdentifierAndLinkNameTuple> var1);

        public Builder parentLinks(ObjectIdentifierAndLinkNameTuple ... var1);

        public Builder parentLinks(Consumer<ObjectIdentifierAndLinkNameTuple.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

