/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateIndex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchCreateIndex> {
    private static final SdkField<List<AttributeKey>> ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderedIndexedAttributeList").getter(BatchCreateIndex.getter(BatchCreateIndex::orderedIndexedAttributeList)).setter(BatchCreateIndex.setter(Builder::orderedIndexedAttributeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedIndexedAttributeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_UNIQUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsUnique").getter(BatchCreateIndex.getter(BatchCreateIndex::isUnique)).setter(BatchCreateIndex.setter(Builder::isUnique)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUnique").build()}).build();
    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParentReference").getter(BatchCreateIndex.getter(BatchCreateIndex::parentReference)).setter(BatchCreateIndex.setter(Builder::parentReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()}).build();
    private static final SdkField<String> LINK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkName").getter(BatchCreateIndex.getter(BatchCreateIndex::linkName)).setter(BatchCreateIndex.setter(Builder::linkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()}).build();
    private static final SdkField<String> BATCH_REFERENCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchReferenceName").getter(BatchCreateIndex.getter(BatchCreateIndex::batchReferenceName)).setter(BatchCreateIndex.setter(Builder::batchReferenceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchReferenceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD, IS_UNIQUE_FIELD, PARENT_REFERENCE_FIELD, LINK_NAME_FIELD, BATCH_REFERENCE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OrderedIndexedAttributeList", ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD);
            this.put("IsUnique", IS_UNIQUE_FIELD);
            this.put("ParentReference", PARENT_REFERENCE_FIELD);
            this.put("LinkName", LINK_NAME_FIELD);
            this.put("BatchReferenceName", BATCH_REFERENCE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<AttributeKey> orderedIndexedAttributeList;
    private final Boolean isUnique;
    private final ObjectReference parentReference;
    private final String linkName;
    private final String batchReferenceName;

    private BatchCreateIndex(BuilderImpl builder) {
        this.orderedIndexedAttributeList = builder.orderedIndexedAttributeList;
        this.isUnique = builder.isUnique;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
        this.batchReferenceName = builder.batchReferenceName;
    }

    public final boolean hasOrderedIndexedAttributeList() {
        return this.orderedIndexedAttributeList != null && !(this.orderedIndexedAttributeList instanceof SdkAutoConstructList);
    }

    public final List<AttributeKey> orderedIndexedAttributeList() {
        return this.orderedIndexedAttributeList;
    }

    public final Boolean isUnique() {
        return this.isUnique;
    }

    public final ObjectReference parentReference() {
        return this.parentReference;
    }

    public final String linkName() {
        return this.linkName;
    }

    public final String batchReferenceName() {
        return this.batchReferenceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderedIndexedAttributeList() ? this.orderedIndexedAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isUnique());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchReferenceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateIndex)) {
            return false;
        }
        BatchCreateIndex other = (BatchCreateIndex)obj;
        return this.hasOrderedIndexedAttributeList() == other.hasOrderedIndexedAttributeList() && Objects.equals(this.orderedIndexedAttributeList(), other.orderedIndexedAttributeList()) && Objects.equals(this.isUnique(), other.isUnique()) && Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.linkName(), other.linkName()) && Objects.equals(this.batchReferenceName(), other.batchReferenceName());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateIndex").add("OrderedIndexedAttributeList", this.hasOrderedIndexedAttributeList() ? this.orderedIndexedAttributeList() : null).add("IsUnique", (Object)this.isUnique()).add("ParentReference", (Object)this.parentReference()).add("LinkName", (Object)this.linkName()).add("BatchReferenceName", (Object)this.batchReferenceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderedIndexedAttributeList": {
                return Optional.ofNullable(clazz.cast(this.orderedIndexedAttributeList()));
            }
            case "IsUnique": {
                return Optional.ofNullable(clazz.cast(this.isUnique()));
            }
            case "ParentReference": {
                return Optional.ofNullable(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.ofNullable(clazz.cast(this.linkName()));
            }
            case "BatchReferenceName": {
                return Optional.ofNullable(clazz.cast(this.batchReferenceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateIndex, T> g) {
        return obj -> g.apply((BatchCreateIndex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeKey> orderedIndexedAttributeList = DefaultSdkAutoConstructList.getInstance();
        private Boolean isUnique;
        private ObjectReference parentReference;
        private String linkName;
        private String batchReferenceName;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateIndex model) {
            this.orderedIndexedAttributeList(model.orderedIndexedAttributeList);
            this.isUnique(model.isUnique);
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
            this.batchReferenceName(model.batchReferenceName);
        }

        public final List<AttributeKey.Builder> getOrderedIndexedAttributeList() {
            List<AttributeKey.Builder> result = AttributeKeyListCopier.copyToBuilder(this.orderedIndexedAttributeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderedIndexedAttributeList(Collection<AttributeKey.BuilderImpl> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copyFromBuilder(orderedIndexedAttributeList);
        }

        @Override
        public final Builder orderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copy(orderedIndexedAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(AttributeKey ... orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList(Arrays.asList(orderedIndexedAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(Consumer<AttributeKey.Builder> ... orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList(Stream.of(orderedIndexedAttributeList).map(c -> (AttributeKey)((AttributeKey.Builder)AttributeKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsUnique() {
            return this.isUnique;
        }

        public final void setIsUnique(Boolean isUnique) {
            this.isUnique = isUnique;
        }

        @Override
        public final Builder isUnique(Boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final String getBatchReferenceName() {
            return this.batchReferenceName;
        }

        public final void setBatchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
        }

        @Override
        public final Builder batchReferenceName(String batchReferenceName) {
            this.batchReferenceName = batchReferenceName;
            return this;
        }

        public BatchCreateIndex build() {
            return new BatchCreateIndex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchCreateIndex> {
        public Builder orderedIndexedAttributeList(Collection<AttributeKey> var1);

        public Builder orderedIndexedAttributeList(AttributeKey ... var1);

        public Builder orderedIndexedAttributeList(Consumer<AttributeKey.Builder> ... var1);

        public Builder isUnique(Boolean var1);

        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(parentReference)).build());
        }

        public Builder linkName(String var1);

        public Builder batchReferenceName(String var1);
    }
}

