/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.internal.UserAgentUtils;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;

public class ListTypedLinkFacetNamesIterable
implements SdkIterable<ListTypedLinkFacetNamesResponse> {
    private final CloudDirectoryClient client;
    private final ListTypedLinkFacetNamesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTypedLinkFacetNamesIterable(CloudDirectoryClient client, ListTypedLinkFacetNamesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTypedLinkFacetNamesResponseFetcher();
    }

    public Iterator<ListTypedLinkFacetNamesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTypedLinkFacetNamesResponseFetcher
    implements SyncPageFetcher<ListTypedLinkFacetNamesResponse> {
        private ListTypedLinkFacetNamesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypedLinkFacetNamesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTypedLinkFacetNamesResponse nextPage(ListTypedLinkFacetNamesResponse previousPage) {
            if (previousPage == null) {
                return ListTypedLinkFacetNamesIterable.this.client.listTypedLinkFacetNames(ListTypedLinkFacetNamesIterable.this.firstRequest);
            }
            return ListTypedLinkFacetNamesIterable.this.client.listTypedLinkFacetNames((ListTypedLinkFacetNamesRequest)((Object)ListTypedLinkFacetNamesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

