/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse;

public class ListAppliedSchemaArnsPublisher
implements SdkPublisher<ListAppliedSchemaArnsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListAppliedSchemaArnsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppliedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListAppliedSchemaArnsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppliedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListAppliedSchemaArnsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppliedSchemaArnsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppliedSchemaArnsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAppliedSchemaArnsResponseFetcher
    implements AsyncPageFetcher<ListAppliedSchemaArnsResponse> {
        private ListAppliedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppliedSchemaArnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAppliedSchemaArnsResponse> nextPage(ListAppliedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListAppliedSchemaArnsPublisher.this.client.listAppliedSchemaArns(ListAppliedSchemaArnsPublisher.this.firstRequest);
            }
            return ListAppliedSchemaArnsPublisher.this.client.listAppliedSchemaArns((ListAppliedSchemaArnsRequest)((Object)ListAppliedSchemaArnsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

