/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.RangeMode;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypedAttributeValueRange
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypedAttributeValueRange> {
    private static final SdkField<String> START_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TypedAttributeValueRange.getter(TypedAttributeValueRange::startModeAsString)).setter(TypedAttributeValueRange.setter(Builder::startMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartMode").build()}).build();
    private static final SdkField<TypedAttributeValue> START_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TypedAttributeValueRange.getter(TypedAttributeValueRange::startValue)).setter(TypedAttributeValueRange.setter(Builder::startValue)).constructor(TypedAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartValue").build()}).build();
    private static final SdkField<String> END_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TypedAttributeValueRange.getter(TypedAttributeValueRange::endModeAsString)).setter(TypedAttributeValueRange.setter(Builder::endMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndMode").build()}).build();
    private static final SdkField<TypedAttributeValue> END_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TypedAttributeValueRange.getter(TypedAttributeValueRange::endValue)).setter(TypedAttributeValueRange.setter(Builder::endValue)).constructor(TypedAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_MODE_FIELD, START_VALUE_FIELD, END_MODE_FIELD, END_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String startMode;
    private final TypedAttributeValue startValue;
    private final String endMode;
    private final TypedAttributeValue endValue;

    private TypedAttributeValueRange(BuilderImpl builder) {
        this.startMode = builder.startMode;
        this.startValue = builder.startValue;
        this.endMode = builder.endMode;
        this.endValue = builder.endValue;
    }

    public RangeMode startMode() {
        return RangeMode.fromValue(this.startMode);
    }

    public String startModeAsString() {
        return this.startMode;
    }

    public TypedAttributeValue startValue() {
        return this.startValue;
    }

    public RangeMode endMode() {
        return RangeMode.fromValue(this.endMode);
    }

    public String endModeAsString() {
        return this.endMode;
    }

    public TypedAttributeValue endValue() {
        return this.endValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.endModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedAttributeValueRange)) {
            return false;
        }
        TypedAttributeValueRange other = (TypedAttributeValueRange)obj;
        return Objects.equals(this.startModeAsString(), other.startModeAsString()) && Objects.equals(this.startValue(), other.startValue()) && Objects.equals(this.endModeAsString(), other.endModeAsString()) && Objects.equals(this.endValue(), other.endValue());
    }

    public String toString() {
        return ToString.builder((String)"TypedAttributeValueRange").add("StartMode", (Object)this.startModeAsString()).add("StartValue", (Object)this.startValue()).add("EndMode", (Object)this.endModeAsString()).add("EndValue", (Object)this.endValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartMode": {
                return Optional.ofNullable(clazz.cast(this.startModeAsString()));
            }
            case "StartValue": {
                return Optional.ofNullable(clazz.cast(this.startValue()));
            }
            case "EndMode": {
                return Optional.ofNullable(clazz.cast(this.endModeAsString()));
            }
            case "EndValue": {
                return Optional.ofNullable(clazz.cast(this.endValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypedAttributeValueRange, T> g) {
        return obj -> g.apply((TypedAttributeValueRange)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String startMode;
        private TypedAttributeValue startValue;
        private String endMode;
        private TypedAttributeValue endValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedAttributeValueRange model) {
            this.startMode(model.startMode);
            this.startValue(model.startValue);
            this.endMode(model.endMode);
            this.endValue(model.endValue);
        }

        public final String getStartMode() {
            return this.startMode;
        }

        @Override
        public final Builder startMode(String startMode) {
            this.startMode = startMode;
            return this;
        }

        @Override
        public final Builder startMode(RangeMode startMode) {
            this.startMode(startMode.toString());
            return this;
        }

        public final void setStartMode(String startMode) {
            this.startMode = startMode;
        }

        public final TypedAttributeValue.Builder getStartValue() {
            return this.startValue != null ? this.startValue.toBuilder() : null;
        }

        @Override
        public final Builder startValue(TypedAttributeValue startValue) {
            this.startValue = startValue;
            return this;
        }

        public final void setStartValue(TypedAttributeValue.BuilderImpl startValue) {
            this.startValue = startValue != null ? startValue.build() : null;
        }

        public final String getEndMode() {
            return this.endMode;
        }

        @Override
        public final Builder endMode(String endMode) {
            this.endMode = endMode;
            return this;
        }

        @Override
        public final Builder endMode(RangeMode endMode) {
            this.endMode(endMode.toString());
            return this;
        }

        public final void setEndMode(String endMode) {
            this.endMode = endMode;
        }

        public final TypedAttributeValue.Builder getEndValue() {
            return this.endValue != null ? this.endValue.toBuilder() : null;
        }

        @Override
        public final Builder endValue(TypedAttributeValue endValue) {
            this.endValue = endValue;
            return this;
        }

        public final void setEndValue(TypedAttributeValue.BuilderImpl endValue) {
            this.endValue = endValue != null ? endValue.build() : null;
        }

        public TypedAttributeValueRange build() {
            return new TypedAttributeValueRange(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypedAttributeValueRange> {
        public Builder startMode(String var1);

        public Builder startMode(RangeMode var1);

        public Builder startValue(TypedAttributeValue var1);

        default public Builder startValue(Consumer<TypedAttributeValue.Builder> startValue) {
            return this.startValue((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().applyMutation(startValue)).build());
        }

        public Builder endMode(String var1);

        public Builder endMode(RangeMode var1);

        public Builder endValue(TypedAttributeValue var1);

        default public Builder endValue(Consumer<TypedAttributeValue.Builder> endValue) {
            return this.endValue((TypedAttributeValue)((TypedAttributeValue.Builder)TypedAttributeValue.builder().applyMutation(endValue)).build());
        }
    }
}

