/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetLinkAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetLinkAttributes> {
    private static final SdkField<TypedLinkSpecifier> TYPED_LINK_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TypedLinkSpecifier").getter(BatchGetLinkAttributes.getter(BatchGetLinkAttributes::typedLinkSpecifier)).setter(BatchGetLinkAttributes.setter(Builder::typedLinkSpecifier)).constructor(TypedLinkSpecifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkSpecifier").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeNames").getter(BatchGetLinkAttributes.getter(BatchGetLinkAttributes::attributeNames)).setter(BatchGetLinkAttributes.setter(Builder::attributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPED_LINK_SPECIFIER_FIELD, ATTRIBUTE_NAMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final TypedLinkSpecifier typedLinkSpecifier;
    private final List<String> attributeNames;

    private BatchGetLinkAttributes(BuilderImpl builder) {
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
        this.attributeNames = builder.attributeNames;
    }

    public final TypedLinkSpecifier typedLinkSpecifier() {
        return this.typedLinkSpecifier;
    }

    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> attributeNames() {
        return this.attributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNames() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetLinkAttributes)) {
            return false;
        }
        BatchGetLinkAttributes other = (BatchGetLinkAttributes)obj;
        return Objects.equals(this.typedLinkSpecifier(), other.typedLinkSpecifier()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNames(), other.attributeNames());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetLinkAttributes").add("TypedLinkSpecifier", (Object)this.typedLinkSpecifier()).add("AttributeNames", this.hasAttributeNames() ? this.attributeNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypedLinkSpecifier": {
                return Optional.ofNullable(clazz.cast(this.typedLinkSpecifier()));
            }
            case "AttributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetLinkAttributes, T> g) {
        return obj -> g.apply((BatchGetLinkAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TypedLinkSpecifier typedLinkSpecifier;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetLinkAttributes model) {
            this.typedLinkSpecifier(model.typedLinkSpecifier);
            this.attributeNames(model.attributeNames);
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return this.typedLinkSpecifier != null ? this.typedLinkSpecifier.toBuilder() : null;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNameListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public BatchGetLinkAttributes build() {
            return new BatchGetLinkAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetLinkAttributes> {
        public Builder typedLinkSpecifier(TypedLinkSpecifier var1);

        default public Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return this.typedLinkSpecifier((TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier)).build());
        }

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);
    }
}

