/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.AccessDeniedException;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.ApplySchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachToIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest;
import software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchReadResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteException;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest;
import software.amazon.awssdk.services.clouddirectory.model.BatchWriteResponse;
import software.amazon.awssdk.services.clouddirectory.model.CannotListParentOfRootException;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryException;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest;
import software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryDeletedException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryNotDisabledException;
import software.amazon.awssdk.services.clouddirectory.model.DirectoryNotEnabledException;
import software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.FacetAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.FacetInUseException;
import software.amazon.awssdk.services.clouddirectory.model.FacetNotFoundException;
import software.amazon.awssdk.services.clouddirectory.model.FacetValidationException;
import software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonResponse;
import software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationRequest;
import software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationResponse;
import software.amazon.awssdk.services.clouddirectory.model.IncompatibleSchemaException;
import software.amazon.awssdk.services.clouddirectory.model.IndexedAttributeMissingException;
import software.amazon.awssdk.services.clouddirectory.model.InternalServiceException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidArnException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidAttachmentException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidFacetUpdateException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidRuleException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidSchemaDocException;
import software.amazon.awssdk.services.clouddirectory.model.InvalidTaggingRequestException;
import software.amazon.awssdk.services.clouddirectory.model.LimitExceededException;
import software.amazon.awssdk.services.clouddirectory.model.LinkNameAlreadyInUseException;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.NotIndexException;
import software.amazon.awssdk.services.clouddirectory.model.NotNodeException;
import software.amazon.awssdk.services.clouddirectory.model.NotPolicyException;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAlreadyDetachedException;
import software.amazon.awssdk.services.clouddirectory.model.ObjectNotDetachedException;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.PublishSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest;
import software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonResponse;
import software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest;
import software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.ResourceNotFoundException;
import software.amazon.awssdk.services.clouddirectory.model.RetryableConflictException;
import software.amazon.awssdk.services.clouddirectory.model.SchemaAlreadyExistsException;
import software.amazon.awssdk.services.clouddirectory.model.SchemaAlreadyPublishedException;
import software.amazon.awssdk.services.clouddirectory.model.StillContainsLinksException;
import software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.TagResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.UnsupportedIndexTypeException;
import software.amazon.awssdk.services.clouddirectory.model.UntagResourceRequest;
import software.amazon.awssdk.services.clouddirectory.model.UntagResourceResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest;
import software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaResponse;
import software.amazon.awssdk.services.clouddirectory.model.ValidationException;
import software.amazon.awssdk.services.clouddirectory.paginators.ListAppliedSchemaArnsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListAttachedIndicesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListDevelopmentSchemaArnsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListDirectoriesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListFacetAttributesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListFacetNamesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListIndexPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListManagedSchemaArnsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectAttributesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectChildrenPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentPathsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectParentsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListObjectPoliciesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListPolicyAttachmentsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListPublishedSchemaArnsPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetAttributesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.ListTypedLinkFacetNamesPublisher;
import software.amazon.awssdk.services.clouddirectory.paginators.LookupPolicyPublisher;
import software.amazon.awssdk.services.clouddirectory.transform.AddFacetToObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ApplySchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachToIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.AttachTypedLinkRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchReadRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.BatchWriteRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.CreateTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DeleteTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachFromIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DetachTypedLinkRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.DisableDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.EnableDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetAppliedSchemaVersionRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetDirectoryRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetLinkAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetObjectInformationRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetSchemaAsJsonRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.GetTypedLinkFacetInformationRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListAppliedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListAttachedIndicesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListDevelopmentSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListFacetAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListFacetNamesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListIncomingTypedLinksRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListIndexRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListManagedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectChildrenRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectParentPathsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectParentsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListObjectPoliciesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListOutgoingTypedLinksRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListPolicyAttachmentsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListPublishedSchemaArnsRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTypedLinkFacetAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.ListTypedLinkFacetNamesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.LookupPolicyRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.PublishSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.PutSchemaFromJsonRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.RemoveFacetFromObjectRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateLinkAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateObjectAttributesRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpdateTypedLinkFacetRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpgradeAppliedSchemaRequestMarshaller;
import software.amazon.awssdk.services.clouddirectory.transform.UpgradePublishedSchemaRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudDirectoryAsyncClient
implements CloudDirectoryAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudDirectoryAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudDirectoryAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "clouddirectory";
    }

    @Override
    public CompletableFuture<AddFacetToObjectResponse> addFacetToObject(AddFacetToObjectRequest addFacetToObjectRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, addFacetToObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFacetToObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFacetToObjectResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFacetToObject").withMarshaller((Marshaller)new AddFacetToObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addFacetToObjectRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = addFacetToObjectRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$addFacetToObject$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$addFacetToObject$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ApplySchemaResponse> applySchema(ApplySchemaRequest applySchemaRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, applySchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ApplySchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ApplySchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ApplySchema").withMarshaller((Marshaller)new ApplySchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)applySchemaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = applySchemaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$applySchema$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$applySchema$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachObjectResponse> attachObject(AttachObjectRequest attachObjectRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachObjectResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachObject").withMarshaller((Marshaller)new AttachObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachObjectRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachObjectRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$attachObject$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$attachObject$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachPolicyResponse> attachPolicy(AttachPolicyRequest attachPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachPolicy").withMarshaller((Marshaller)new AttachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$attachPolicy$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$attachPolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachToIndexResponse> attachToIndex(AttachToIndexRequest attachToIndexRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachToIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachToIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachToIndexResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachToIndex").withMarshaller((Marshaller)new AttachToIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachToIndexRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachToIndexRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$attachToIndex$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$attachToIndex$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AttachTypedLinkResponse> attachTypedLink(AttachTypedLinkRequest attachTypedLinkRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, attachTypedLinkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AttachTypedLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachTypedLinkResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachTypedLink").withMarshaller((Marshaller)new AttachTypedLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)attachTypedLinkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = attachTypedLinkRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$attachTypedLink$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$attachTypedLink$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchReadResponse> batchRead(BatchReadRequest batchReadRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchReadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchRead");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchReadResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchRead").withMarshaller((Marshaller)new BatchReadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchReadRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchReadRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$batchRead$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$batchRead$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchWriteResponse> batchWrite(BatchWriteRequest batchWriteRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchWriteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchWrite");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchWriteResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchWrite").withMarshaller((Marshaller)new BatchWriteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchWriteRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = batchWriteRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$batchWrite$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$batchWrite$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateDirectoryResponse> createDirectory(CreateDirectoryRequest createDirectoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDirectory").withMarshaller((Marshaller)new CreateDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$createDirectory$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$createDirectory$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFacetResponse> createFacet(CreateFacetRequest createFacetRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFacetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFacet").withMarshaller((Marshaller)new CreateFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFacetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createFacetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$createFacet$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$createFacet$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateIndexResponse> createIndex(CreateIndexRequest createIndexRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateIndexResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateIndex").withMarshaller((Marshaller)new CreateIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createIndexRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createIndexRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$createIndex$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$createIndex$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateObjectResponse> createObject(CreateObjectRequest createObjectRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateObjectResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateObject").withMarshaller((Marshaller)new CreateObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createObjectRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createObjectRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$createObject$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$createObject$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateSchemaResponse> createSchema(CreateSchemaRequest createSchemaRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSchema").withMarshaller((Marshaller)new CreateSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSchemaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createSchemaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$createSchema$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$createSchema$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTypedLinkFacetResponse> createTypedLinkFacet(CreateTypedLinkFacetRequest createTypedLinkFacetRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, createTypedLinkFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTypedLinkFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTypedLinkFacetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTypedLinkFacet").withMarshaller((Marshaller)new CreateTypedLinkFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createTypedLinkFacetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = createTypedLinkFacetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$createTypedLinkFacet$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$createTypedLinkFacet$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDirectoryResponse> deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDirectory").withMarshaller((Marshaller)new DeleteDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$deleteDirectory$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$deleteDirectory$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFacetResponse> deleteFacet(DeleteFacetRequest deleteFacetRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFacetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFacet").withMarshaller((Marshaller)new DeleteFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFacetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteFacetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$deleteFacet$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$deleteFacet$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteObjectResponse> deleteObject(DeleteObjectRequest deleteObjectRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteObjectResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteObject").withMarshaller((Marshaller)new DeleteObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteObjectRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteObjectRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$deleteObject$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$deleteObject$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSchemaResponse> deleteSchema(DeleteSchemaRequest deleteSchemaRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSchema").withMarshaller((Marshaller)new DeleteSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSchemaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteSchemaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$deleteSchema$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$deleteSchema$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTypedLinkFacetResponse> deleteTypedLinkFacet(DeleteTypedLinkFacetRequest deleteTypedLinkFacetRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTypedLinkFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTypedLinkFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTypedLinkFacetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTypedLinkFacet").withMarshaller((Marshaller)new DeleteTypedLinkFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteTypedLinkFacetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = deleteTypedLinkFacetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$deleteTypedLinkFacet$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$deleteTypedLinkFacet$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachFromIndexResponse> detachFromIndex(DetachFromIndexRequest detachFromIndexRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, detachFromIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachFromIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachFromIndexResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachFromIndex").withMarshaller((Marshaller)new DetachFromIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachFromIndexRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachFromIndexRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$detachFromIndex$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$detachFromIndex$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachObjectResponse> detachObject(DetachObjectRequest detachObjectRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, detachObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachObjectResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachObject").withMarshaller((Marshaller)new DetachObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachObjectRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachObjectRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$detachObject$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$detachObject$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachPolicyResponse> detachPolicy(DetachPolicyRequest detachPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, detachPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachPolicy").withMarshaller((Marshaller)new DetachPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$detachPolicy$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$detachPolicy$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DetachTypedLinkResponse> detachTypedLink(DetachTypedLinkRequest detachTypedLinkRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, detachTypedLinkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DetachTypedLink");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachTypedLinkResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachTypedLink").withMarshaller((Marshaller)new DetachTypedLinkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)detachTypedLinkRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = detachTypedLinkRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$detachTypedLink$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$detachTypedLink$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableDirectoryResponse> disableDirectory(DisableDirectoryRequest disableDirectoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDirectory").withMarshaller((Marshaller)new DisableDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = disableDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$disableDirectory$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$disableDirectory$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableDirectoryResponse> enableDirectory(EnableDirectoryRequest enableDirectoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDirectory").withMarshaller((Marshaller)new EnableDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = enableDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$enableDirectory$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$enableDirectory$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAppliedSchemaVersionResponse> getAppliedSchemaVersion(GetAppliedSchemaVersionRequest getAppliedSchemaVersionRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getAppliedSchemaVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAppliedSchemaVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAppliedSchemaVersionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAppliedSchemaVersion").withMarshaller((Marshaller)new GetAppliedSchemaVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAppliedSchemaVersionRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getAppliedSchemaVersionRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$getAppliedSchemaVersion$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$getAppliedSchemaVersion$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDirectoryResponse> getDirectory(GetDirectoryRequest getDirectoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDirectoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDirectory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDirectoryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDirectory").withMarshaller((Marshaller)new GetDirectoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDirectoryRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getDirectoryRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$getDirectory$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$getDirectory$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFacetResponse> getFacet(GetFacetRequest getFacetRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFacetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFacet").withMarshaller((Marshaller)new GetFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFacetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getFacetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$getFacet$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$getFacet$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetLinkAttributesResponse> getLinkAttributes(GetLinkAttributesRequest getLinkAttributesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getLinkAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLinkAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLinkAttributesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLinkAttributes").withMarshaller((Marshaller)new GetLinkAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getLinkAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getLinkAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$getLinkAttributes$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$getLinkAttributes$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetObjectAttributesResponse> getObjectAttributes(GetObjectAttributesRequest getObjectAttributesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getObjectAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetObjectAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetObjectAttributesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectAttributes").withMarshaller((Marshaller)new GetObjectAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getObjectAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getObjectAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$getObjectAttributes$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$getObjectAttributes$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetObjectInformationResponse> getObjectInformation(GetObjectInformationRequest getObjectInformationRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getObjectInformationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetObjectInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetObjectInformationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetObjectInformation").withMarshaller((Marshaller)new GetObjectInformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getObjectInformationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getObjectInformationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$getObjectInformation$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$getObjectInformation$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSchemaAsJsonResponse> getSchemaAsJson(GetSchemaAsJsonRequest getSchemaAsJsonRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getSchemaAsJsonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSchemaAsJson");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSchemaAsJsonResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSchemaAsJson").withMarshaller((Marshaller)new GetSchemaAsJsonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSchemaAsJsonRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getSchemaAsJsonRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$getSchemaAsJson$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$getSchemaAsJson$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTypedLinkFacetInformationResponse> getTypedLinkFacetInformation(GetTypedLinkFacetInformationRequest getTypedLinkFacetInformationRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, getTypedLinkFacetInformationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTypedLinkFacetInformation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTypedLinkFacetInformationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTypedLinkFacetInformation").withMarshaller((Marshaller)new GetTypedLinkFacetInformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTypedLinkFacetInformationRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = getTypedLinkFacetInformationRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$getTypedLinkFacetInformation$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$getTypedLinkFacetInformation$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListAppliedSchemaArnsResponse> listAppliedSchemaArns(ListAppliedSchemaArnsRequest listAppliedSchemaArnsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAppliedSchemaArnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAppliedSchemaArns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAppliedSchemaArnsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAppliedSchemaArns").withMarshaller((Marshaller)new ListAppliedSchemaArnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAppliedSchemaArnsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAppliedSchemaArnsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listAppliedSchemaArns$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listAppliedSchemaArns$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAppliedSchemaArnsPublisher listAppliedSchemaArnsPaginator(ListAppliedSchemaArnsRequest listAppliedSchemaArnsRequest) {
        return new ListAppliedSchemaArnsPublisher(this, this.applyPaginatorUserAgent(listAppliedSchemaArnsRequest));
    }

    @Override
    public CompletableFuture<ListAttachedIndicesResponse> listAttachedIndices(ListAttachedIndicesRequest listAttachedIndicesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listAttachedIndicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAttachedIndices");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAttachedIndicesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAttachedIndices").withMarshaller((Marshaller)new ListAttachedIndicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listAttachedIndicesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listAttachedIndicesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listAttachedIndices$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listAttachedIndices$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListAttachedIndicesPublisher listAttachedIndicesPaginator(ListAttachedIndicesRequest listAttachedIndicesRequest) {
        return new ListAttachedIndicesPublisher(this, this.applyPaginatorUserAgent(listAttachedIndicesRequest));
    }

    @Override
    public CompletableFuture<ListDevelopmentSchemaArnsResponse> listDevelopmentSchemaArns(ListDevelopmentSchemaArnsRequest listDevelopmentSchemaArnsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDevelopmentSchemaArnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDevelopmentSchemaArns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevelopmentSchemaArnsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevelopmentSchemaArns").withMarshaller((Marshaller)new ListDevelopmentSchemaArnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDevelopmentSchemaArnsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDevelopmentSchemaArnsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listDevelopmentSchemaArns$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listDevelopmentSchemaArns$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListDevelopmentSchemaArnsPublisher listDevelopmentSchemaArnsPaginator(ListDevelopmentSchemaArnsRequest listDevelopmentSchemaArnsRequest) {
        return new ListDevelopmentSchemaArnsPublisher(this, this.applyPaginatorUserAgent(listDevelopmentSchemaArnsRequest));
    }

    @Override
    public CompletableFuture<ListDirectoriesResponse> listDirectories(ListDirectoriesRequest listDirectoriesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDirectoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDirectories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDirectoriesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDirectories").withMarshaller((Marshaller)new ListDirectoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDirectoriesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listDirectoriesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listDirectories$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listDirectories$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListDirectoriesPublisher listDirectoriesPaginator(ListDirectoriesRequest listDirectoriesRequest) {
        return new ListDirectoriesPublisher(this, this.applyPaginatorUserAgent(listDirectoriesRequest));
    }

    @Override
    public CompletableFuture<ListFacetAttributesResponse> listFacetAttributes(ListFacetAttributesRequest listFacetAttributesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFacetAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFacetAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFacetAttributesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFacetAttributes").withMarshaller((Marshaller)new ListFacetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFacetAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFacetAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listFacetAttributes$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listFacetAttributes$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListFacetAttributesPublisher listFacetAttributesPaginator(ListFacetAttributesRequest listFacetAttributesRequest) {
        return new ListFacetAttributesPublisher(this, this.applyPaginatorUserAgent(listFacetAttributesRequest));
    }

    @Override
    public CompletableFuture<ListFacetNamesResponse> listFacetNames(ListFacetNamesRequest listFacetNamesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listFacetNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFacetNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFacetNamesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFacetNames").withMarshaller((Marshaller)new ListFacetNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFacetNamesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listFacetNamesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listFacetNames$115(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listFacetNames$116((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListFacetNamesPublisher listFacetNamesPaginator(ListFacetNamesRequest listFacetNamesRequest) {
        return new ListFacetNamesPublisher(this, this.applyPaginatorUserAgent(listFacetNamesRequest));
    }

    @Override
    public CompletableFuture<ListIncomingTypedLinksResponse> listIncomingTypedLinks(ListIncomingTypedLinksRequest listIncomingTypedLinksRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listIncomingTypedLinksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIncomingTypedLinks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIncomingTypedLinksResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIncomingTypedLinks").withMarshaller((Marshaller)new ListIncomingTypedLinksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIncomingTypedLinksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listIncomingTypedLinksRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listIncomingTypedLinks$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listIncomingTypedLinks$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListIndexResponse> listIndex(ListIndexRequest listIndexRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listIndexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListIndex");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListIndexResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListIndex").withMarshaller((Marshaller)new ListIndexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listIndexRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listIndexRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listIndex$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listIndex$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListIndexPublisher listIndexPaginator(ListIndexRequest listIndexRequest) {
        return new ListIndexPublisher(this, this.applyPaginatorUserAgent(listIndexRequest));
    }

    @Override
    public CompletableFuture<ListManagedSchemaArnsResponse> listManagedSchemaArns(ListManagedSchemaArnsRequest listManagedSchemaArnsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listManagedSchemaArnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListManagedSchemaArns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListManagedSchemaArnsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListManagedSchemaArns").withMarshaller((Marshaller)new ListManagedSchemaArnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listManagedSchemaArnsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listManagedSchemaArnsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listManagedSchemaArns$124(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listManagedSchemaArns$125((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListManagedSchemaArnsPublisher listManagedSchemaArnsPaginator(ListManagedSchemaArnsRequest listManagedSchemaArnsRequest) {
        return new ListManagedSchemaArnsPublisher(this, this.applyPaginatorUserAgent(listManagedSchemaArnsRequest));
    }

    @Override
    public CompletableFuture<ListObjectAttributesResponse> listObjectAttributes(ListObjectAttributesRequest listObjectAttributesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listObjectAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectAttributesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectAttributes").withMarshaller((Marshaller)new ListObjectAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listObjectAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listObjectAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listObjectAttributes$127(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listObjectAttributes$128((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListObjectAttributesPublisher listObjectAttributesPaginator(ListObjectAttributesRequest listObjectAttributesRequest) {
        return new ListObjectAttributesPublisher(this, this.applyPaginatorUserAgent(listObjectAttributesRequest));
    }

    @Override
    public CompletableFuture<ListObjectChildrenResponse> listObjectChildren(ListObjectChildrenRequest listObjectChildrenRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listObjectChildrenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectChildren");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectChildrenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectChildren").withMarshaller((Marshaller)new ListObjectChildrenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listObjectChildrenRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listObjectChildrenRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listObjectChildren$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listObjectChildren$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListObjectChildrenPublisher listObjectChildrenPaginator(ListObjectChildrenRequest listObjectChildrenRequest) {
        return new ListObjectChildrenPublisher(this, this.applyPaginatorUserAgent(listObjectChildrenRequest));
    }

    @Override
    public CompletableFuture<ListObjectParentPathsResponse> listObjectParentPaths(ListObjectParentPathsRequest listObjectParentPathsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listObjectParentPathsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectParentPaths");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectParentPathsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectParentPaths").withMarshaller((Marshaller)new ListObjectParentPathsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listObjectParentPathsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listObjectParentPathsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listObjectParentPaths$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listObjectParentPaths$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListObjectParentPathsPublisher listObjectParentPathsPaginator(ListObjectParentPathsRequest listObjectParentPathsRequest) {
        return new ListObjectParentPathsPublisher(this, this.applyPaginatorUserAgent(listObjectParentPathsRequest));
    }

    @Override
    public CompletableFuture<ListObjectParentsResponse> listObjectParents(ListObjectParentsRequest listObjectParentsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listObjectParentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectParents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectParentsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectParents").withMarshaller((Marshaller)new ListObjectParentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listObjectParentsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listObjectParentsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listObjectParents$136(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listObjectParents$137((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListObjectParentsPublisher listObjectParentsPaginator(ListObjectParentsRequest listObjectParentsRequest) {
        return new ListObjectParentsPublisher(this, this.applyPaginatorUserAgent(listObjectParentsRequest));
    }

    @Override
    public CompletableFuture<ListObjectPoliciesResponse> listObjectPolicies(ListObjectPoliciesRequest listObjectPoliciesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listObjectPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListObjectPolicies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListObjectPoliciesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListObjectPolicies").withMarshaller((Marshaller)new ListObjectPoliciesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listObjectPoliciesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listObjectPoliciesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listObjectPolicies$139(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listObjectPolicies$140((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListObjectPoliciesPublisher listObjectPoliciesPaginator(ListObjectPoliciesRequest listObjectPoliciesRequest) {
        return new ListObjectPoliciesPublisher(this, this.applyPaginatorUserAgent(listObjectPoliciesRequest));
    }

    @Override
    public CompletableFuture<ListOutgoingTypedLinksResponse> listOutgoingTypedLinks(ListOutgoingTypedLinksRequest listOutgoingTypedLinksRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listOutgoingTypedLinksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOutgoingTypedLinks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOutgoingTypedLinksResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOutgoingTypedLinks").withMarshaller((Marshaller)new ListOutgoingTypedLinksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listOutgoingTypedLinksRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listOutgoingTypedLinksRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listOutgoingTypedLinks$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listOutgoingTypedLinks$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListPolicyAttachmentsResponse> listPolicyAttachments(ListPolicyAttachmentsRequest listPolicyAttachmentsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listPolicyAttachmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPolicyAttachments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPolicyAttachmentsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPolicyAttachments").withMarshaller((Marshaller)new ListPolicyAttachmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPolicyAttachmentsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPolicyAttachmentsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listPolicyAttachments$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listPolicyAttachments$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListPolicyAttachmentsPublisher listPolicyAttachmentsPaginator(ListPolicyAttachmentsRequest listPolicyAttachmentsRequest) {
        return new ListPolicyAttachmentsPublisher(this, this.applyPaginatorUserAgent(listPolicyAttachmentsRequest));
    }

    @Override
    public CompletableFuture<ListPublishedSchemaArnsResponse> listPublishedSchemaArns(ListPublishedSchemaArnsRequest listPublishedSchemaArnsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listPublishedSchemaArnsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPublishedSchemaArns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPublishedSchemaArnsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPublishedSchemaArns").withMarshaller((Marshaller)new ListPublishedSchemaArnsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listPublishedSchemaArnsRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listPublishedSchemaArnsRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listPublishedSchemaArns$148(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listPublishedSchemaArns$149((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListPublishedSchemaArnsPublisher listPublishedSchemaArnsPaginator(ListPublishedSchemaArnsRequest listPublishedSchemaArnsRequest) {
        return new ListPublishedSchemaArnsPublisher(this, this.applyPaginatorUserAgent(listPublishedSchemaArnsRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTagsForResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listTagsForResource$151(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listTagsForResource$152((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    @Override
    public CompletableFuture<ListTypedLinkFacetAttributesResponse> listTypedLinkFacetAttributes(ListTypedLinkFacetAttributesRequest listTypedLinkFacetAttributesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTypedLinkFacetAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTypedLinkFacetAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypedLinkFacetAttributesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypedLinkFacetAttributes").withMarshaller((Marshaller)new ListTypedLinkFacetAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTypedLinkFacetAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTypedLinkFacetAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listTypedLinkFacetAttributes$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listTypedLinkFacetAttributes$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTypedLinkFacetAttributesPublisher listTypedLinkFacetAttributesPaginator(ListTypedLinkFacetAttributesRequest listTypedLinkFacetAttributesRequest) {
        return new ListTypedLinkFacetAttributesPublisher(this, this.applyPaginatorUserAgent(listTypedLinkFacetAttributesRequest));
    }

    @Override
    public CompletableFuture<ListTypedLinkFacetNamesResponse> listTypedLinkFacetNames(ListTypedLinkFacetNamesRequest listTypedLinkFacetNamesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTypedLinkFacetNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTypedLinkFacetNames");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTypedLinkFacetNamesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTypedLinkFacetNames").withMarshaller((Marshaller)new ListTypedLinkFacetNamesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTypedLinkFacetNamesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = listTypedLinkFacetNamesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$listTypedLinkFacetNames$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$listTypedLinkFacetNames$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTypedLinkFacetNamesPublisher listTypedLinkFacetNamesPaginator(ListTypedLinkFacetNamesRequest listTypedLinkFacetNamesRequest) {
        return new ListTypedLinkFacetNamesPublisher(this, this.applyPaginatorUserAgent(listTypedLinkFacetNamesRequest));
    }

    @Override
    public CompletableFuture<LookupPolicyResponse> lookupPolicy(LookupPolicyRequest lookupPolicyRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, lookupPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"LookupPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, LookupPolicyResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("LookupPolicy").withMarshaller((Marshaller)new LookupPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)lookupPolicyRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = lookupPolicyRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$lookupPolicy$160(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$lookupPolicy$161((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public LookupPolicyPublisher lookupPolicyPaginator(LookupPolicyRequest lookupPolicyRequest) {
        return new LookupPolicyPublisher(this, this.applyPaginatorUserAgent(lookupPolicyRequest));
    }

    @Override
    public CompletableFuture<PublishSchemaResponse> publishSchema(PublishSchemaRequest publishSchemaRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, publishSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PublishSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PublishSchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PublishSchema").withMarshaller((Marshaller)new PublishSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)publishSchemaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = publishSchemaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$publishSchema$163(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$publishSchema$164((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutSchemaFromJsonResponse> putSchemaFromJson(PutSchemaFromJsonRequest putSchemaFromJsonRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, putSchemaFromJsonRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSchemaFromJson");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSchemaFromJsonResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSchemaFromJson").withMarshaller((Marshaller)new PutSchemaFromJsonRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putSchemaFromJsonRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = putSchemaFromJsonRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$putSchemaFromJson$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$putSchemaFromJson$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveFacetFromObjectResponse> removeFacetFromObject(RemoveFacetFromObjectRequest removeFacetFromObjectRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, removeFacetFromObjectRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFacetFromObject");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFacetFromObjectResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFacetFromObject").withMarshaller((Marshaller)new RemoveFacetFromObjectRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeFacetFromObjectRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = removeFacetFromObjectRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$removeFacetFromObject$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$removeFacetFromObject$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = tagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$tagResource$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$tagResource$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = untagResourceRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$untagResource$175(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$untagResource$176((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFacetResponse> updateFacet(UpdateFacetRequest updateFacetRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFacetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFacet").withMarshaller((Marshaller)new UpdateFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFacetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateFacetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$updateFacet$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$updateFacet$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLinkAttributesResponse> updateLinkAttributes(UpdateLinkAttributesRequest updateLinkAttributesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateLinkAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLinkAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLinkAttributesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLinkAttributes").withMarshaller((Marshaller)new UpdateLinkAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLinkAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateLinkAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$updateLinkAttributes$181(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$updateLinkAttributes$182((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateObjectAttributesResponse> updateObjectAttributes(UpdateObjectAttributesRequest updateObjectAttributesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateObjectAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateObjectAttributes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateObjectAttributesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateObjectAttributes").withMarshaller((Marshaller)new UpdateObjectAttributesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateObjectAttributesRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateObjectAttributesRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$updateObjectAttributes$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$updateObjectAttributes$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSchemaResponse> updateSchema(UpdateSchemaRequest updateSchemaRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSchema").withMarshaller((Marshaller)new UpdateSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSchemaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateSchemaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$updateSchema$187(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$updateSchema$188((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTypedLinkFacetResponse> updateTypedLinkFacet(UpdateTypedLinkFacetRequest updateTypedLinkFacetRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTypedLinkFacetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTypedLinkFacet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTypedLinkFacetResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTypedLinkFacet").withMarshaller((Marshaller)new UpdateTypedLinkFacetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTypedLinkFacetRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = updateTypedLinkFacetRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$updateTypedLinkFacet$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$updateTypedLinkFacet$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpgradeAppliedSchemaResponse> upgradeAppliedSchema(UpgradeAppliedSchemaRequest upgradeAppliedSchemaRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, upgradeAppliedSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpgradeAppliedSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradeAppliedSchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradeAppliedSchema").withMarshaller((Marshaller)new UpgradeAppliedSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)upgradeAppliedSchemaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = upgradeAppliedSchemaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$upgradeAppliedSchema$193(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$upgradeAppliedSchema$194((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpgradePublishedSchemaResponse> upgradePublishedSchema(UpgradePublishedSchemaRequest upgradePublishedSchemaRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudDirectoryAsyncClient.resolveMetricPublishers(this.clientConfiguration, upgradePublishedSchemaRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudDirectory");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpgradePublishedSchema");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpgradePublishedSchemaResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpgradePublishedSchema").withMarshaller((Marshaller)new UpgradePublishedSchemaRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)upgradePublishedSchemaRequest));
            AwsRequestOverrideConfiguration requestOverrideConfig = upgradePublishedSchemaRequest.overrideConfiguration().orElse(null);
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudDirectoryAsyncClient.lambda$upgradePublishedSchema$196(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudDirectoryAsyncClient.lambda$upgradePublishedSchema$197((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudDirectoryException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArnException").exceptionBuilderSupplier(InvalidArnException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FacetInUseException").exceptionBuilderSupplier(FacetInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidAttachmentException").exceptionBuilderSupplier(InvalidAttachmentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IndexedAttributeMissingException").exceptionBuilderSupplier(IndexedAttributeMissingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleSchemaException").exceptionBuilderSupplier(IncompatibleSchemaException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SchemaAlreadyPublishedException").exceptionBuilderSupplier(SchemaAlreadyPublishedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("StillContainsLinksException").exceptionBuilderSupplier(StillContainsLinksException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRuleException").exceptionBuilderSupplier(InvalidRuleException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryNotEnabledException").exceptionBuilderSupplier(DirectoryNotEnabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FacetValidationException").exceptionBuilderSupplier(FacetValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFacetUpdateException").exceptionBuilderSupplier(InvalidFacetUpdateException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SchemaAlreadyExistsException").exceptionBuilderSupplier(SchemaAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceException").exceptionBuilderSupplier(InternalServiceException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FacetAlreadyExistsException").exceptionBuilderSupplier(FacetAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotIndexException").exceptionBuilderSupplier(NotIndexException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectAlreadyDetachedException").exceptionBuilderSupplier(ObjectAlreadyDetachedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryDeletedException").exceptionBuilderSupplier(DirectoryDeletedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RetryableConflictException").exceptionBuilderSupplier(RetryableConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BatchWriteException").exceptionBuilderSupplier(BatchWriteException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTaggingRequestException").exceptionBuilderSupplier(InvalidTaggingRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotNodeException").exceptionBuilderSupplier(NotNodeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryAlreadyExistsException").exceptionBuilderSupplier(DirectoryAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DirectoryNotDisabledException").exceptionBuilderSupplier(DirectoryNotDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSchemaDocException").exceptionBuilderSupplier(InvalidSchemaDocException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ObjectNotDetachedException").exceptionBuilderSupplier(ObjectNotDetachedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LinkNameAlreadyInUseException").exceptionBuilderSupplier(LinkNameAlreadyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CannotListParentOfRootException").exceptionBuilderSupplier(CannotListParentOfRootException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotPolicyException").exceptionBuilderSupplier(NotPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("FacetNotFoundException").exceptionBuilderSupplier(FacetNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedIndexTypeException").exceptionBuilderSupplier(UnsupportedIndexTypeException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends CloudDirectoryRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.58").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudDirectoryRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private static /* synthetic */ void lambda$upgradePublishedSchema$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$upgradePublishedSchema$196(List metricPublishers, MetricCollector apiCallMetricCollector, UpgradePublishedSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$upgradeAppliedSchema$194(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$upgradeAppliedSchema$193(List metricPublishers, MetricCollector apiCallMetricCollector, UpgradeAppliedSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTypedLinkFacet$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTypedLinkFacet$190(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTypedLinkFacetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSchema$188(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSchema$187(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateObjectAttributes$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateObjectAttributes$184(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateObjectAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLinkAttributes$182(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLinkAttributes$181(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLinkAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFacet$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFacet$178(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFacetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$176(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$175(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$172(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeFacetFromObject$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFacetFromObject$169(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveFacetFromObjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putSchemaFromJson$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSchemaFromJson$166(List metricPublishers, MetricCollector apiCallMetricCollector, PutSchemaFromJsonResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$publishSchema$164(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$publishSchema$163(List metricPublishers, MetricCollector apiCallMetricCollector, PublishSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$lookupPolicy$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$lookupPolicy$160(List metricPublishers, MetricCollector apiCallMetricCollector, LookupPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTypedLinkFacetNames$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTypedLinkFacetNames$157(List metricPublishers, MetricCollector apiCallMetricCollector, ListTypedLinkFacetNamesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTypedLinkFacetAttributes$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTypedLinkFacetAttributes$154(List metricPublishers, MetricCollector apiCallMetricCollector, ListTypedLinkFacetAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$152(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$151(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPublishedSchemaArns$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPublishedSchemaArns$148(List metricPublishers, MetricCollector apiCallMetricCollector, ListPublishedSchemaArnsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listPolicyAttachments$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPolicyAttachments$145(List metricPublishers, MetricCollector apiCallMetricCollector, ListPolicyAttachmentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listOutgoingTypedLinks$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOutgoingTypedLinks$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListOutgoingTypedLinksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listObjectPolicies$140(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectPolicies$139(List metricPublishers, MetricCollector apiCallMetricCollector, ListObjectPoliciesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listObjectParents$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectParents$136(List metricPublishers, MetricCollector apiCallMetricCollector, ListObjectParentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listObjectParentPaths$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectParentPaths$133(List metricPublishers, MetricCollector apiCallMetricCollector, ListObjectParentPathsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listObjectChildren$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectChildren$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListObjectChildrenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listObjectAttributes$128(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listObjectAttributes$127(List metricPublishers, MetricCollector apiCallMetricCollector, ListObjectAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listManagedSchemaArns$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listManagedSchemaArns$124(List metricPublishers, MetricCollector apiCallMetricCollector, ListManagedSchemaArnsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listIndex$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIndex$121(List metricPublishers, MetricCollector apiCallMetricCollector, ListIndexResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listIncomingTypedLinks$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listIncomingTypedLinks$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListIncomingTypedLinksResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFacetNames$116(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFacetNames$115(List metricPublishers, MetricCollector apiCallMetricCollector, ListFacetNamesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFacetAttributes$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFacetAttributes$112(List metricPublishers, MetricCollector apiCallMetricCollector, ListFacetAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDirectories$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDirectories$109(List metricPublishers, MetricCollector apiCallMetricCollector, ListDirectoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDevelopmentSchemaArns$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDevelopmentSchemaArns$106(List metricPublishers, MetricCollector apiCallMetricCollector, ListDevelopmentSchemaArnsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAttachedIndices$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAttachedIndices$103(List metricPublishers, MetricCollector apiCallMetricCollector, ListAttachedIndicesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listAppliedSchemaArns$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAppliedSchemaArns$100(List metricPublishers, MetricCollector apiCallMetricCollector, ListAppliedSchemaArnsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTypedLinkFacetInformation$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTypedLinkFacetInformation$97(List metricPublishers, MetricCollector apiCallMetricCollector, GetTypedLinkFacetInformationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSchemaAsJson$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSchemaAsJson$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetSchemaAsJsonResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getObjectInformation$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getObjectInformation$91(List metricPublishers, MetricCollector apiCallMetricCollector, GetObjectInformationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getObjectAttributes$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getObjectAttributes$88(List metricPublishers, MetricCollector apiCallMetricCollector, GetObjectAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getLinkAttributes$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLinkAttributes$85(List metricPublishers, MetricCollector apiCallMetricCollector, GetLinkAttributesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFacet$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFacet$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetFacetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDirectory$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDirectory$79(List metricPublishers, MetricCollector apiCallMetricCollector, GetDirectoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAppliedSchemaVersion$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAppliedSchemaVersion$76(List metricPublishers, MetricCollector apiCallMetricCollector, GetAppliedSchemaVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableDirectory$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableDirectory$73(List metricPublishers, MetricCollector apiCallMetricCollector, EnableDirectoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableDirectory$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableDirectory$70(List metricPublishers, MetricCollector apiCallMetricCollector, DisableDirectoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachTypedLink$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachTypedLink$67(List metricPublishers, MetricCollector apiCallMetricCollector, DetachTypedLinkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachPolicy$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachPolicy$64(List metricPublishers, MetricCollector apiCallMetricCollector, DetachPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachObject$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachObject$61(List metricPublishers, MetricCollector apiCallMetricCollector, DetachObjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$detachFromIndex$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$detachFromIndex$58(List metricPublishers, MetricCollector apiCallMetricCollector, DetachFromIndexResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTypedLinkFacet$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTypedLinkFacet$55(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTypedLinkFacetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSchema$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSchema$52(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteObject$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteObject$49(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteObjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFacet$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFacet$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFacetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDirectory$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDirectory$43(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDirectoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTypedLinkFacet$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTypedLinkFacet$40(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTypedLinkFacetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSchema$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSchema$37(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createObject$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createObject$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateObjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createIndex$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createIndex$31(List metricPublishers, MetricCollector apiCallMetricCollector, CreateIndexResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFacet$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFacet$28(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFacetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDirectory$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDirectory$25(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDirectoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchWrite$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchWrite$22(List metricPublishers, MetricCollector apiCallMetricCollector, BatchWriteResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchRead$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchRead$19(List metricPublishers, MetricCollector apiCallMetricCollector, BatchReadResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachTypedLink$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachTypedLink$16(List metricPublishers, MetricCollector apiCallMetricCollector, AttachTypedLinkResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachToIndex$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachToIndex$13(List metricPublishers, MetricCollector apiCallMetricCollector, AttachToIndexResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachPolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachPolicy$10(List metricPublishers, MetricCollector apiCallMetricCollector, AttachPolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$attachObject$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$attachObject$7(List metricPublishers, MetricCollector apiCallMetricCollector, AttachObjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$applySchema$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$applySchema$4(List metricPublishers, MetricCollector apiCallMetricCollector, ApplySchemaResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addFacetToObject$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFacetToObject$1(List metricPublishers, MetricCollector apiCallMetricCollector, AddFacetToObjectResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

