/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.PolicyToPath;
import software.amazon.awssdk.services.clouddirectory.model.PolicyToPathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchLookupPolicyResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchLookupPolicyResponse> {
    private static final SdkField<List<PolicyToPath>> POLICY_TO_PATH_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyToPathList").getter(BatchLookupPolicyResponse.getter(BatchLookupPolicyResponse::policyToPathList)).setter(BatchLookupPolicyResponse.setter(Builder::policyToPathList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyToPathList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyToPath::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchLookupPolicyResponse.getter(BatchLookupPolicyResponse::nextToken)).setter(BatchLookupPolicyResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_TO_PATH_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PolicyToPath> policyToPathList;
    private final String nextToken;

    private BatchLookupPolicyResponse(BuilderImpl builder) {
        this.policyToPathList = builder.policyToPathList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPolicyToPathList() {
        return this.policyToPathList != null && !(this.policyToPathList instanceof SdkAutoConstructList);
    }

    public final List<PolicyToPath> policyToPathList() {
        return this.policyToPathList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyToPathList() ? this.policyToPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLookupPolicyResponse)) {
            return false;
        }
        BatchLookupPolicyResponse other = (BatchLookupPolicyResponse)obj;
        return this.hasPolicyToPathList() == other.hasPolicyToPathList() && Objects.equals(this.policyToPathList(), other.policyToPathList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchLookupPolicyResponse").add("PolicyToPathList", this.hasPolicyToPathList() ? this.policyToPathList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyToPathList": {
                return Optional.ofNullable(clazz.cast(this.policyToPathList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchLookupPolicyResponse, T> g) {
        return obj -> g.apply((BatchLookupPolicyResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PolicyToPath> policyToPathList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLookupPolicyResponse model) {
            this.policyToPathList(model.policyToPathList);
            this.nextToken(model.nextToken);
        }

        public final List<PolicyToPath.Builder> getPolicyToPathList() {
            List<PolicyToPath.Builder> result = PolicyToPathListCopier.copyToBuilder(this.policyToPathList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder policyToPathList(Collection<PolicyToPath> policyToPathList) {
            this.policyToPathList = PolicyToPathListCopier.copy(policyToPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyToPathList(PolicyToPath ... policyToPathList) {
            this.policyToPathList(Arrays.asList(policyToPathList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyToPathList(Consumer<PolicyToPath.Builder> ... policyToPathList) {
            this.policyToPathList(Stream.of(policyToPathList).map(c -> (PolicyToPath)((PolicyToPath.Builder)PolicyToPath.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyToPathList(Collection<PolicyToPath.BuilderImpl> policyToPathList) {
            this.policyToPathList = PolicyToPathListCopier.copyFromBuilder(policyToPathList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public BatchLookupPolicyResponse build() {
            return new BatchLookupPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchLookupPolicyResponse> {
        public Builder policyToPathList(Collection<PolicyToPath> var1);

        public Builder policyToPathList(PolicyToPath ... var1);

        public Builder policyToPathList(Consumer<PolicyToPath.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

