/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse;

public class ListDirectoriesIterable
implements SdkIterable<ListDirectoriesResponse> {
    private final CloudDirectoryClient client;
    private final ListDirectoriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDirectoriesIterable(CloudDirectoryClient client, ListDirectoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDirectoriesResponseFetcher();
    }

    public Iterator<ListDirectoriesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDirectoriesResponseFetcher
    implements SyncPageFetcher<ListDirectoriesResponse> {
        private ListDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListDirectoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDirectoriesResponse nextPage(ListDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return ListDirectoriesIterable.this.client.listDirectories(ListDirectoriesIterable.this.firstRequest);
            }
            return ListDirectoriesIterable.this.client.listDirectories((ListDirectoriesRequest)((Object)ListDirectoriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

