/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachment;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIndexResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListIndexResponse> {
    private static final SdkField<List<IndexAttachment>> INDEX_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IndexAttachments").getter(ListIndexResponse.getter(ListIndexResponse::indexAttachments)).setter(ListIndexResponse.setter(Builder::indexAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IndexAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIndexResponse.getter(ListIndexResponse::nextToken)).setter(ListIndexResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ATTACHMENTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<IndexAttachment> indexAttachments;
    private final String nextToken;

    private ListIndexResponse(BuilderImpl builder) {
        super(builder);
        this.indexAttachments = builder.indexAttachments;
        this.nextToken = builder.nextToken;
    }

    public boolean hasIndexAttachments() {
        return this.indexAttachments != null && !(this.indexAttachments instanceof SdkAutoConstructList);
    }

    public List<IndexAttachment> indexAttachments() {
        return this.indexAttachments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexResponse)) {
            return false;
        }
        ListIndexResponse other = (ListIndexResponse)((Object)obj);
        return Objects.equals(this.indexAttachments(), other.indexAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIndexResponse").add("IndexAttachments", this.indexAttachments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexAttachments": {
                return Optional.ofNullable(clazz.cast(this.indexAttachments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIndexResponse, T> g) {
        return obj -> g.apply((ListIndexResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<IndexAttachment> indexAttachments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndexResponse model) {
            super(model);
            this.indexAttachments(model.indexAttachments);
            this.nextToken(model.nextToken);
        }

        public final Collection<IndexAttachment.Builder> getIndexAttachments() {
            return this.indexAttachments != null ? (Collection)this.indexAttachments.stream().map(IndexAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder indexAttachments(Collection<IndexAttachment> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copy(indexAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(IndexAttachment ... indexAttachments) {
            this.indexAttachments(Arrays.asList(indexAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(Consumer<IndexAttachment.Builder> ... indexAttachments) {
            this.indexAttachments(Stream.of(indexAttachments).map(c -> (IndexAttachment)((IndexAttachment.Builder)IndexAttachment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIndexAttachments(Collection<IndexAttachment.BuilderImpl> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copyFromBuilder(indexAttachments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIndexResponse build() {
            return new ListIndexResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIndexResponse> {
        public Builder indexAttachments(Collection<IndexAttachment> var1);

        public Builder indexAttachments(IndexAttachment ... var1);

        public Builder indexAttachments(Consumer<IndexAttachment.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

