/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplySchemaRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, ApplySchemaRequest> {
    private static final SdkField<String> PUBLISHED_SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublishedSchemaArn").getter(ApplySchemaRequest.getter(ApplySchemaRequest::publishedSchemaArn)).setter(ApplySchemaRequest.setter(Builder::publishedSchemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedSchemaArn").build()}).build();
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(ApplySchemaRequest.getter(ApplySchemaRequest::directoryArn)).setter(ApplySchemaRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISHED_SCHEMA_ARN_FIELD, DIRECTORY_ARN_FIELD));
    private final String publishedSchemaArn;
    private final String directoryArn;

    private ApplySchemaRequest(BuilderImpl builder) {
        super(builder);
        this.publishedSchemaArn = builder.publishedSchemaArn;
        this.directoryArn = builder.directoryArn;
    }

    public final String publishedSchemaArn() {
        return this.publishedSchemaArn;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.publishedSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplySchemaRequest)) {
            return false;
        }
        ApplySchemaRequest other = (ApplySchemaRequest)((Object)obj);
        return Objects.equals(this.publishedSchemaArn(), other.publishedSchemaArn()) && Objects.equals(this.directoryArn(), other.directoryArn());
    }

    public final String toString() {
        return ToString.builder((String)"ApplySchemaRequest").add("PublishedSchemaArn", (Object)this.publishedSchemaArn()).add("DirectoryArn", (Object)this.directoryArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PublishedSchemaArn": {
                return Optional.ofNullable(clazz.cast(this.publishedSchemaArn()));
            }
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplySchemaRequest, T> g) {
        return obj -> g.apply((ApplySchemaRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String publishedSchemaArn;
        private String directoryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplySchemaRequest model) {
            super(model);
            this.publishedSchemaArn(model.publishedSchemaArn);
            this.directoryArn(model.directoryArn);
        }

        public final String getPublishedSchemaArn() {
            return this.publishedSchemaArn;
        }

        @Override
        public final Builder publishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
            return this;
        }

        public final void setPublishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApplySchemaRequest build() {
            return new ApplySchemaRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApplySchemaRequest> {
        public Builder publishedSchemaArn(String var1);

        public Builder directoryArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

