/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FacetAttributeReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FacetAttributeReference> {
    private static final SdkField<String> TARGET_FACET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetFacetName").getter(FacetAttributeReference.getter(FacetAttributeReference::targetFacetName)).setter(FacetAttributeReference.setter(Builder::targetFacetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetFacetName").build()}).build();
    private static final SdkField<String> TARGET_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetAttributeName").getter(FacetAttributeReference.getter(FacetAttributeReference::targetAttributeName)).setter(FacetAttributeReference.setter(Builder::targetAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAttributeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FACET_NAME_FIELD, TARGET_ATTRIBUTE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetFacetName;
    private final String targetAttributeName;

    private FacetAttributeReference(BuilderImpl builder) {
        this.targetFacetName = builder.targetFacetName;
        this.targetAttributeName = builder.targetAttributeName;
    }

    public String targetFacetName() {
        return this.targetFacetName;
    }

    public String targetAttributeName() {
        return this.targetAttributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetFacetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAttributeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttributeReference)) {
            return false;
        }
        FacetAttributeReference other = (FacetAttributeReference)obj;
        return Objects.equals(this.targetFacetName(), other.targetFacetName()) && Objects.equals(this.targetAttributeName(), other.targetAttributeName());
    }

    public String toString() {
        return ToString.builder((String)"FacetAttributeReference").add("TargetFacetName", (Object)this.targetFacetName()).add("TargetAttributeName", (Object)this.targetAttributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetFacetName": {
                return Optional.ofNullable(clazz.cast(this.targetFacetName()));
            }
            case "TargetAttributeName": {
                return Optional.ofNullable(clazz.cast(this.targetAttributeName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FacetAttributeReference, T> g) {
        return obj -> g.apply((FacetAttributeReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetFacetName;
        private String targetAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttributeReference model) {
            this.targetFacetName(model.targetFacetName);
            this.targetAttributeName(model.targetAttributeName);
        }

        public final String getTargetFacetName() {
            return this.targetFacetName;
        }

        @Override
        public final Builder targetFacetName(String targetFacetName) {
            this.targetFacetName = targetFacetName;
            return this;
        }

        public final void setTargetFacetName(String targetFacetName) {
            this.targetFacetName = targetFacetName;
        }

        public final String getTargetAttributeName() {
            return this.targetAttributeName;
        }

        @Override
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        public FacetAttributeReference build() {
            return new FacetAttributeReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FacetAttributeReference> {
        public Builder targetFacetName(String var1);

        public Builder targetAttributeName(String var1);
    }
}

