/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKey;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIndexRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, CreateIndexRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(CreateIndexRequest.getter(CreateIndexRequest::directoryArn)).setter(CreateIndexRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<List<AttributeKey>> ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderedIndexedAttributeList").getter(CreateIndexRequest.getter(CreateIndexRequest::orderedIndexedAttributeList)).setter(CreateIndexRequest.setter(Builder::orderedIndexedAttributeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderedIndexedAttributeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_UNIQUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsUnique").getter(CreateIndexRequest.getter(CreateIndexRequest::isUnique)).setter(CreateIndexRequest.setter(Builder::isUnique)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUnique").build()}).build();
    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParentReference").getter(CreateIndexRequest.getter(CreateIndexRequest::parentReference)).setter(CreateIndexRequest.setter(Builder::parentReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()}).build();
    private static final SdkField<String> LINK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkName").getter(CreateIndexRequest.getter(CreateIndexRequest::linkName)).setter(CreateIndexRequest.setter(Builder::linkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, ORDERED_INDEXED_ATTRIBUTE_LIST_FIELD, IS_UNIQUE_FIELD, PARENT_REFERENCE_FIELD, LINK_NAME_FIELD));
    private final String directoryArn;
    private final List<AttributeKey> orderedIndexedAttributeList;
    private final Boolean isUnique;
    private final ObjectReference parentReference;
    private final String linkName;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.orderedIndexedAttributeList = builder.orderedIndexedAttributeList;
        this.isUnique = builder.isUnique;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public boolean hasOrderedIndexedAttributeList() {
        return this.orderedIndexedAttributeList != null && !(this.orderedIndexedAttributeList instanceof SdkAutoConstructList);
    }

    public List<AttributeKey> orderedIndexedAttributeList() {
        return this.orderedIndexedAttributeList;
    }

    public Boolean isUnique() {
        return this.isUnique;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.orderedIndexedAttributeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.isUnique());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.orderedIndexedAttributeList(), other.orderedIndexedAttributeList()) && Objects.equals(this.isUnique(), other.isUnique()) && Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.linkName(), other.linkName());
    }

    public String toString() {
        return ToString.builder((String)"CreateIndexRequest").add("DirectoryArn", (Object)this.directoryArn()).add("OrderedIndexedAttributeList", this.orderedIndexedAttributeList()).add("IsUnique", (Object)this.isUnique()).add("ParentReference", (Object)this.parentReference()).add("LinkName", (Object)this.linkName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "OrderedIndexedAttributeList": {
                return Optional.ofNullable(clazz.cast(this.orderedIndexedAttributeList()));
            }
            case "IsUnique": {
                return Optional.ofNullable(clazz.cast(this.isUnique()));
            }
            case "ParentReference": {
                return Optional.ofNullable(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.ofNullable(clazz.cast(this.linkName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexRequest, T> g) {
        return obj -> g.apply((CreateIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<AttributeKey> orderedIndexedAttributeList = DefaultSdkAutoConstructList.getInstance();
        private Boolean isUnique;
        private ObjectReference parentReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.orderedIndexedAttributeList(model.orderedIndexedAttributeList);
            this.isUnique(model.isUnique);
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<AttributeKey.Builder> getOrderedIndexedAttributeList() {
            return this.orderedIndexedAttributeList != null ? (Collection)this.orderedIndexedAttributeList.stream().map(AttributeKey::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderedIndexedAttributeList(Collection<AttributeKey> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copy(orderedIndexedAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(AttributeKey ... orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList(Arrays.asList(orderedIndexedAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderedIndexedAttributeList(Consumer<AttributeKey.Builder> ... orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList(Stream.of(orderedIndexedAttributeList).map(c -> (AttributeKey)((AttributeKey.Builder)AttributeKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderedIndexedAttributeList(Collection<AttributeKey.BuilderImpl> orderedIndexedAttributeList) {
            this.orderedIndexedAttributeList = AttributeKeyListCopier.copyFromBuilder(orderedIndexedAttributeList);
        }

        public final Boolean getIsUnique() {
            return this.isUnique;
        }

        @Override
        public final Builder isUnique(Boolean isUnique) {
            this.isUnique = isUnique;
            return this;
        }

        public final void setIsUnique(Boolean isUnique) {
            this.isUnique = isUnique;
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIndexRequest> {
        public Builder directoryArn(String var1);

        public Builder orderedIndexedAttributeList(Collection<AttributeKey> var1);

        public Builder orderedIndexedAttributeList(AttributeKey ... var1);

        public Builder orderedIndexedAttributeList(Consumer<AttributeKey.Builder> ... var1);

        public Builder isUnique(Boolean var1);

        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(parentReference)).build());
        }

        public Builder linkName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

