/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IndexAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IndexAttachment> {
    private static final SdkField<List<AttributeKeyAndValue>> INDEXED_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(IndexAttachment.getter(IndexAttachment::indexedAttributes)).setter(IndexAttachment.setter(Builder::indexedAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexedAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeKeyAndValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IndexAttachment.getter(IndexAttachment::objectIdentifier)).setter(IndexAttachment.setter(Builder::objectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEXED_ATTRIBUTES_FIELD, OBJECT_IDENTIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<AttributeKeyAndValue> indexedAttributes;
    private final String objectIdentifier;

    private IndexAttachment(BuilderImpl builder) {
        this.indexedAttributes = builder.indexedAttributes;
        this.objectIdentifier = builder.objectIdentifier;
    }

    public List<AttributeKeyAndValue> indexedAttributes() {
        return this.indexedAttributes;
    }

    public String objectIdentifier() {
        return this.objectIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexedAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexAttachment)) {
            return false;
        }
        IndexAttachment other = (IndexAttachment)obj;
        return Objects.equals(this.indexedAttributes(), other.indexedAttributes()) && Objects.equals(this.objectIdentifier(), other.objectIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"IndexAttachment").add("IndexedAttributes", this.indexedAttributes()).add("ObjectIdentifier", (Object)this.objectIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexedAttributes": {
                return Optional.ofNullable(clazz.cast(this.indexedAttributes()));
            }
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexAttachment, T> g) {
        return obj -> g.apply((IndexAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeKeyAndValue> indexedAttributes = DefaultSdkAutoConstructList.getInstance();
        private String objectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexAttachment model) {
            this.indexedAttributes(model.indexedAttributes);
            this.objectIdentifier(model.objectIdentifier);
        }

        public final Collection<AttributeKeyAndValue.Builder> getIndexedAttributes() {
            return this.indexedAttributes != null ? (Collection)this.indexedAttributes.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder indexedAttributes(Collection<AttributeKeyAndValue> indexedAttributes) {
            this.indexedAttributes = AttributeKeyAndValueListCopier.copy(indexedAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexedAttributes(AttributeKeyAndValue ... indexedAttributes) {
            this.indexedAttributes(Arrays.asList(indexedAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexedAttributes(Consumer<AttributeKeyAndValue.Builder> ... indexedAttributes) {
            this.indexedAttributes(Stream.of(indexedAttributes).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIndexedAttributes(Collection<AttributeKeyAndValue.BuilderImpl> indexedAttributes) {
            this.indexedAttributes = AttributeKeyAndValueListCopier.copyFromBuilder(indexedAttributes);
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        public IndexAttachment build() {
            return new IndexAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IndexAttachment> {
        public Builder indexedAttributes(Collection<AttributeKeyAndValue> var1);

        public Builder indexedAttributes(AttributeKeyAndValue ... var1);

        public Builder indexedAttributes(Consumer<AttributeKeyAndValue.Builder> ... var1);

        public Builder objectIdentifier(String var1);
    }
}

