/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse;

public class ListPublishedSchemaArnsIterable
implements SdkIterable<ListPublishedSchemaArnsResponse> {
    private final CloudDirectoryClient client;
    private final ListPublishedSchemaArnsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPublishedSchemaArnsIterable(CloudDirectoryClient client, ListPublishedSchemaArnsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPublishedSchemaArnsResponseFetcher();
    }

    public Iterator<ListPublishedSchemaArnsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListPublishedSchemaArnsIterable resume(ListPublishedSchemaArnsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListPublishedSchemaArnsIterable(this.client, (ListPublishedSchemaArnsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListPublishedSchemaArnsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListPublishedSchemaArnsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListPublishedSchemaArnsResponseFetcher
    implements SyncPageFetcher<ListPublishedSchemaArnsResponse> {
        private ListPublishedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListPublishedSchemaArnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPublishedSchemaArnsResponse nextPage(ListPublishedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListPublishedSchemaArnsIterable.this.client.listPublishedSchemaArns(ListPublishedSchemaArnsIterable.this.firstRequest);
            }
            return ListPublishedSchemaArnsIterable.this.client.listPublishedSchemaArns((ListPublishedSchemaArnsRequest)((Object)ListPublishedSchemaArnsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

