/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchListObjectPolicies;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchListObjectPoliciesMarshaller {
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxResults").isBinary(false).build();
    private static final BatchListObjectPoliciesMarshaller INSTANCE = new BatchListObjectPoliciesMarshaller();

    private BatchListObjectPoliciesMarshaller() {
    }

    public static BatchListObjectPoliciesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchListObjectPolicies batchListObjectPolicies, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchListObjectPolicies, (String)"batchListObjectPolicies");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchListObjectPolicies.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchListObjectPolicies.nextToken(), NEXTTOKEN_BINDING);
            protocolMarshaller.marshall((Object)batchListObjectPolicies.maxResults(), MAXRESULTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

