/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndex;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchCreateIndexMarshaller {
    private static final MarshallingInfo<List> ORDEREDINDEXEDATTRIBUTELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderedIndexedAttributeList").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISUNIQUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsUnique").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PARENTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentReference").isBinary(false).build();
    private static final MarshallingInfo<String> LINKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LinkName").isBinary(false).build();
    private static final MarshallingInfo<String> BATCHREFERENCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BatchReferenceName").isBinary(false).build();
    private static final BatchCreateIndexMarshaller INSTANCE = new BatchCreateIndexMarshaller();

    private BatchCreateIndexMarshaller() {
    }

    public static BatchCreateIndexMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchCreateIndex batchCreateIndex, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchCreateIndex, (String)"batchCreateIndex");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(batchCreateIndex.orderedIndexedAttributeList(), ORDEREDINDEXEDATTRIBUTELIST_BINDING);
            protocolMarshaller.marshall((Object)batchCreateIndex.isUnique(), ISUNIQUE_BINDING);
            protocolMarshaller.marshall((Object)batchCreateIndex.parentReference(), PARENTREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)batchCreateIndex.linkName(), LINKNAME_BINDING);
            protocolMarshaller.marshall((Object)batchCreateIndex.batchReferenceName(), BATCHREFERENCENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

