/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest;
import software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse;

public class LookupPolicyIterable
implements SdkIterable<LookupPolicyResponse> {
    private final CloudDirectoryClient client;
    private final LookupPolicyRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public LookupPolicyIterable(CloudDirectoryClient client, LookupPolicyRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new LookupPolicyResponseFetcher();
    }

    public Iterator<LookupPolicyResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final LookupPolicyIterable resume(LookupPolicyResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new LookupPolicyIterable(this.client, (LookupPolicyRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new LookupPolicyIterable(this.client, this.firstRequest){

            @Override
            public Iterator<LookupPolicyResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class LookupPolicyResponseFetcher
    implements SyncPageFetcher<LookupPolicyResponse> {
        private LookupPolicyResponseFetcher() {
        }

        public boolean hasNextPage(LookupPolicyResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public LookupPolicyResponse nextPage(LookupPolicyResponse previousPage) {
            if (previousPage == null) {
                return LookupPolicyIterable.this.client.lookupPolicy(LookupPolicyIterable.this.firstRequest);
            }
            return LookupPolicyIterable.this.client.lookupPolicy((LookupPolicyRequest)((Object)LookupPolicyIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

