/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse;

public class ListObjectPoliciesIterable
implements SdkIterable<ListObjectPoliciesResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListObjectPoliciesIterable(CloudDirectoryClient client, ListObjectPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectPoliciesResponseFetcher();
    }

    public Iterator<ListObjectPoliciesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListObjectPoliciesIterable resume(ListObjectPoliciesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListObjectPoliciesIterable(this.client, (ListObjectPoliciesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListObjectPoliciesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListObjectPoliciesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListObjectPoliciesResponseFetcher
    implements SyncPageFetcher<ListObjectPoliciesResponse> {
        private ListObjectPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectPoliciesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListObjectPoliciesResponse nextPage(ListObjectPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectPoliciesIterable.this.client.listObjectPolicies(ListObjectPoliciesIterable.this.firstRequest);
            }
            return ListObjectPoliciesIterable.this.client.listObjectPolicies((ListObjectPoliciesRequest)((Object)ListObjectPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

