/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse;

public class ListAppliedSchemaArnsPublisher
implements SdkPublisher<ListAppliedSchemaArnsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListAppliedSchemaArnsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAppliedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListAppliedSchemaArnsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAppliedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListAppliedSchemaArnsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAppliedSchemaArnsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAppliedSchemaArnsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListAppliedSchemaArnsPublisher resume(ListAppliedSchemaArnsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAppliedSchemaArnsPublisher(this.client, (ListAppliedSchemaArnsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAppliedSchemaArnsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAppliedSchemaArnsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAppliedSchemaArnsResponseFetcher
    implements AsyncPageFetcher<ListAppliedSchemaArnsResponse> {
        private ListAppliedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppliedSchemaArnsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListAppliedSchemaArnsResponse> nextPage(ListAppliedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListAppliedSchemaArnsPublisher.this.client.listAppliedSchemaArns(ListAppliedSchemaArnsPublisher.this.firstRequest);
            }
            return ListAppliedSchemaArnsPublisher.this.client.listAppliedSchemaArns((ListAppliedSchemaArnsRequest)((Object)ListAppliedSchemaArnsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

