/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.transform.AttributeKeyMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributeKey
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributeKey> {
    private final String schemaArn;
    private final String facetName;
    private final String name;

    private AttributeKey(BuilderImpl builder) {
        this.schemaArn = builder.schemaArn;
        this.facetName = builder.facetName;
        this.name = builder.name;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String facetName() {
        return this.facetName;
    }

    public String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeKey)) {
            return false;
        }
        AttributeKey other = (AttributeKey)obj;
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.facetName(), other.facetName()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"AttributeKey").add("SchemaArn", (Object)this.schemaArn()).add("FacetName", (Object)this.facetName()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.of(clazz.cast(this.schemaArn()));
            }
            case "FacetName": {
                return Optional.of(clazz.cast(this.facetName()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributeKeyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String schemaArn;
        private String facetName;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeKey model) {
            this.schemaArn(model.schemaArn);
            this.facetName(model.facetName);
            this.name(model.name);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getFacetName() {
            return this.facetName;
        }

        @Override
        public final Builder facetName(String facetName) {
            this.facetName = facetName;
            return this;
        }

        public final void setFacetName(String facetName) {
            this.facetName = facetName;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public AttributeKey build() {
            return new AttributeKey(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributeKey> {
        public Builder schemaArn(String var1);

        public Builder facetName(String var1);

        public Builder name(String var1);
    }
}

