/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;

@SdkInternalApi
public class SchemaFacetMarshaller {
    private static final MarshallingInfo<String> SCHEMAARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SchemaArn").build();
    private static final MarshallingInfo<String> FACETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FacetName").build();
    private static final SchemaFacetMarshaller INSTANCE = new SchemaFacetMarshaller();

    public static SchemaFacetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SchemaFacet schemaFacet, ProtocolMarshaller protocolMarshaller) {
        if (schemaFacet == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)schemaFacet.schemaArn(), SCHEMAARN_BINDING);
            protocolMarshaller.marshall((Object)schemaFacet.facetName(), FACETNAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

