/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest;

@SdkInternalApi
public class DeleteObjectRequestModelMarshaller {
    private static final MarshallingInfo<String> DIRECTORYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-data-partition").build();
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").build();
    private static final DeleteObjectRequestModelMarshaller INSTANCE = new DeleteObjectRequestModelMarshaller();

    public static DeleteObjectRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeleteObjectRequest deleteObjectRequest, ProtocolMarshaller protocolMarshaller) {
        if (deleteObjectRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)deleteObjectRequest.directoryArn(), DIRECTORYARN_BINDING);
            protocolMarshaller.marshall((Object)deleteObjectRequest.objectReference(), OBJECTREFERENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

