/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.BatchListIndexResponse;

@SdkInternalApi
public class BatchListIndexResponseMarshaller {
    private static final MarshallingInfo<List> INDEXATTACHMENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexAttachments").build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextToken").build();
    private static final BatchListIndexResponseMarshaller INSTANCE = new BatchListIndexResponseMarshaller();

    public static BatchListIndexResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchListIndexResponse batchListIndexResponse, ProtocolMarshaller protocolMarshaller) {
        if (batchListIndexResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(batchListIndexResponse.indexAttachments(), INDEXATTACHMENTS_BINDING);
            protocolMarshaller.marshall((Object)batchListIndexResponse.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

