/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse;

public final class ListPolicyAttachmentsPaginator
implements SdkIterable<ListPolicyAttachmentsResponse> {
    private final CloudDirectoryClient client;
    private final ListPolicyAttachmentsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListPolicyAttachmentsPaginator(CloudDirectoryClient client, ListPolicyAttachmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPolicyAttachmentsResponseFetcher();
    }

    public Iterator<ListPolicyAttachmentsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListPolicyAttachmentsResponseFetcher
    implements NextPageFetcher<ListPolicyAttachmentsResponse> {
        private ListPolicyAttachmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyAttachmentsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListPolicyAttachmentsResponse nextPage(ListPolicyAttachmentsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyAttachmentsPaginator.this.client.listPolicyAttachments(ListPolicyAttachmentsPaginator.this.firstRequest);
            }
            return ListPolicyAttachmentsPaginator.this.client.listPolicyAttachments((ListPolicyAttachmentsRequest)((Object)ListPolicyAttachmentsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

