/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse;

public final class ListDirectoriesPaginator
implements SdkIterable<ListDirectoriesResponse> {
    private final CloudDirectoryClient client;
    private final ListDirectoriesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDirectoriesPaginator(CloudDirectoryClient client, ListDirectoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDirectoriesResponseFetcher();
    }

    public Iterator<ListDirectoriesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListDirectoriesResponseFetcher
    implements NextPageFetcher<ListDirectoriesResponse> {
        private ListDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListDirectoriesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDirectoriesResponse nextPage(ListDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return ListDirectoriesPaginator.this.client.listDirectories(ListDirectoriesPaginator.this.firstRequest);
            }
            return ListDirectoriesPaginator.this.client.listDirectories((ListDirectoriesRequest)((Object)ListDirectoriesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

