/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesResponse;

public final class ListAttachedIndicesPaginator
implements SdkIterable<ListAttachedIndicesResponse> {
    private final CloudDirectoryClient client;
    private final ListAttachedIndicesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListAttachedIndicesPaginator(CloudDirectoryClient client, ListAttachedIndicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAttachedIndicesResponseFetcher();
    }

    public Iterator<ListAttachedIndicesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListAttachedIndicesResponseFetcher
    implements NextPageFetcher<ListAttachedIndicesResponse> {
        private ListAttachedIndicesResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachedIndicesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListAttachedIndicesResponse nextPage(ListAttachedIndicesResponse previousPage) {
            if (previousPage == null) {
                return ListAttachedIndicesPaginator.this.client.listAttachedIndices(ListAttachedIndicesPaginator.this.firstRequest);
            }
            return ListAttachedIndicesPaginator.this.client.listAttachedIndices((ListAttachedIndicesRequest)((Object)ListAttachedIndicesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

