/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.clouddirectory.model.ArnsCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDevelopmentSchemaArnsResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListDevelopmentSchemaArnsResponse> {
    private final List<String> schemaArns;
    private final String nextToken;

    private ListDevelopmentSchemaArnsResponse(BuilderImpl builder) {
        super(builder);
        this.schemaArns = builder.schemaArns;
        this.nextToken = builder.nextToken;
    }

    public List<String> schemaArns() {
        return this.schemaArns;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArns());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevelopmentSchemaArnsResponse)) {
            return false;
        }
        ListDevelopmentSchemaArnsResponse other = (ListDevelopmentSchemaArnsResponse)((Object)obj);
        return Objects.equals(this.schemaArns(), other.schemaArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDevelopmentSchemaArnsResponse").add("SchemaArns", this.schemaArns()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArns": {
                return Optional.of(clazz.cast(this.schemaArns()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<String> schemaArns;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevelopmentSchemaArnsResponse model) {
            this.schemaArns(model.schemaArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getSchemaArns() {
            return this.schemaArns;
        }

        @Override
        public final Builder schemaArns(Collection<String> schemaArns) {
            this.schemaArns = ArnsCopier.copy(schemaArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaArns(String ... schemaArns) {
            this.schemaArns(Arrays.asList(schemaArns));
            return this;
        }

        public final void setSchemaArns(Collection<String> schemaArns) {
            this.schemaArns = ArnsCopier.copy(schemaArns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDevelopmentSchemaArnsResponse build() {
            return new ListDevelopmentSchemaArnsResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListDevelopmentSchemaArnsResponse> {
        public Builder schemaArns(Collection<String> var1);

        public Builder schemaArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

