/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachment;
import software.amazon.awssdk.services.clouddirectory.model.IndexAttachmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListAttachedIndicesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, ListAttachedIndicesResponse> {
    private final List<IndexAttachment> indexAttachments;
    private final String nextToken;

    private ListAttachedIndicesResponse(BuilderImpl builder) {
        super(builder);
        this.indexAttachments = builder.indexAttachments;
        this.nextToken = builder.nextToken;
    }

    public List<IndexAttachment> indexAttachments() {
        return this.indexAttachments;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedIndicesResponse)) {
            return false;
        }
        ListAttachedIndicesResponse other = (ListAttachedIndicesResponse)((Object)obj);
        return Objects.equals(this.indexAttachments(), other.indexAttachments()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAttachedIndicesResponse").add("IndexAttachments", this.indexAttachments()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexAttachments": {
                return Optional.of(clazz.cast(this.indexAttachments()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<IndexAttachment> indexAttachments;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedIndicesResponse model) {
            this.indexAttachments(model.indexAttachments);
            this.nextToken(model.nextToken);
        }

        public final Collection<IndexAttachment.Builder> getIndexAttachments() {
            return this.indexAttachments != null ? (Collection)this.indexAttachments.stream().map(IndexAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder indexAttachments(Collection<IndexAttachment> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copy(indexAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexAttachments(IndexAttachment ... indexAttachments) {
            this.indexAttachments(Arrays.asList(indexAttachments));
            return this;
        }

        public final void setIndexAttachments(Collection<IndexAttachment.BuilderImpl> indexAttachments) {
            this.indexAttachments = IndexAttachmentListCopier.copyFromBuilder(indexAttachments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAttachedIndicesResponse build() {
            return new ListAttachedIndicesResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, ListAttachedIndicesResponse> {
        public Builder indexAttachments(Collection<IndexAttachment> var1);

        public Builder indexAttachments(IndexAttachment ... var1);

        public Builder nextToken(String var1);
    }
}

