/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.transform.FacetAttributeReferenceMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FacetAttributeReference
implements StructuredPojo,
ToCopyableBuilder<Builder, FacetAttributeReference> {
    private final String targetFacetName;
    private final String targetAttributeName;

    private FacetAttributeReference(BuilderImpl builder) {
        this.targetFacetName = builder.targetFacetName;
        this.targetAttributeName = builder.targetAttributeName;
    }

    public String targetFacetName() {
        return this.targetFacetName;
    }

    public String targetAttributeName() {
        return this.targetAttributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetFacetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAttributeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttributeReference)) {
            return false;
        }
        FacetAttributeReference other = (FacetAttributeReference)obj;
        return Objects.equals(this.targetFacetName(), other.targetFacetName()) && Objects.equals(this.targetAttributeName(), other.targetAttributeName());
    }

    public String toString() {
        return ToString.builder((String)"FacetAttributeReference").add("TargetFacetName", (Object)this.targetFacetName()).add("TargetAttributeName", (Object)this.targetAttributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetFacetName": {
                return Optional.of(clazz.cast(this.targetFacetName()));
            }
            case "TargetAttributeName": {
                return Optional.of(clazz.cast(this.targetAttributeName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FacetAttributeReferenceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetFacetName;
        private String targetAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttributeReference model) {
            this.targetFacetName(model.targetFacetName);
            this.targetAttributeName(model.targetAttributeName);
        }

        public final String getTargetFacetName() {
            return this.targetFacetName;
        }

        @Override
        public final Builder targetFacetName(String targetFacetName) {
            this.targetFacetName = targetFacetName;
            return this;
        }

        public final void setTargetFacetName(String targetFacetName) {
            this.targetFacetName = targetFacetName;
        }

        public final String getTargetAttributeName() {
            return this.targetAttributeName;
        }

        @Override
        public final Builder targetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
            return this;
        }

        public final void setTargetAttributeName(String targetAttributeName) {
            this.targetAttributeName = targetAttributeName;
        }

        public FacetAttributeReference build() {
            return new FacetAttributeReference(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FacetAttributeReference> {
        public Builder targetFacetName(String var1);

        public Builder targetAttributeName(String var1);
    }
}

