/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;

@SdkInternalApi
public class ObjectReferenceMarshaller {
    private static final MarshallingInfo<String> SELECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Selector").build();
    private static final ObjectReferenceMarshaller INSTANCE = new ObjectReferenceMarshaller();

    public static ObjectReferenceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ObjectReference objectReference, ProtocolMarshaller protocolMarshaller) {
        if (objectReference == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)objectReference.selector(), SELECTOR_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

