/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesResponse;

public final class ListTypedLinkFacetAttributesPaginator
implements SdkIterable<ListTypedLinkFacetAttributesResponse> {
    private final CloudDirectoryClient client;
    private final ListTypedLinkFacetAttributesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListTypedLinkFacetAttributesPaginator(CloudDirectoryClient client, ListTypedLinkFacetAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTypedLinkFacetAttributesResponseFetcher();
    }

    public Iterator<ListTypedLinkFacetAttributesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListTypedLinkFacetAttributesResponseFetcher
    implements NextPageFetcher<ListTypedLinkFacetAttributesResponse> {
        private ListTypedLinkFacetAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListTypedLinkFacetAttributesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListTypedLinkFacetAttributesResponse nextPage(ListTypedLinkFacetAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListTypedLinkFacetAttributesPaginator.this.client.listTypedLinkFacetAttributes(ListTypedLinkFacetAttributesPaginator.this.firstRequest);
            }
            return ListTypedLinkFacetAttributesPaginator.this.client.listTypedLinkFacetAttributes((ListTypedLinkFacetAttributesRequest)((Object)ListTypedLinkFacetAttributesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

