/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsResponse;

public final class ListObjectParentPathsPaginator
implements SdkIterable<ListObjectParentPathsResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectParentPathsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListObjectParentPathsPaginator(CloudDirectoryClient client, ListObjectParentPathsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectParentPathsResponseFetcher();
    }

    public Iterator<ListObjectParentPathsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListObjectParentPathsResponseFetcher
    implements NextPageFetcher<ListObjectParentPathsResponse> {
        private ListObjectParentPathsResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectParentPathsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListObjectParentPathsResponse nextPage(ListObjectParentPathsResponse previousPage) {
            if (previousPage == null) {
                return ListObjectParentPathsPaginator.this.client.listObjectParentPaths(ListObjectParentPathsPaginator.this.firstRequest);
            }
            return ListObjectParentPathsPaginator.this.client.listObjectParentPaths((ListObjectParentPathsRequest)((Object)ListObjectParentPathsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

