/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesResponse;

public final class ListObjectAttributesPaginator
implements SdkIterable<ListObjectAttributesResponse> {
    private final CloudDirectoryClient client;
    private final ListObjectAttributesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListObjectAttributesPaginator(CloudDirectoryClient client, ListObjectAttributesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListObjectAttributesResponseFetcher();
    }

    public Iterator<ListObjectAttributesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListObjectAttributesResponseFetcher
    implements NextPageFetcher<ListObjectAttributesResponse> {
        private ListObjectAttributesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectAttributesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListObjectAttributesResponse nextPage(ListObjectAttributesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectAttributesPaginator.this.client.listObjectAttributes(ListObjectAttributesPaginator.this.firstRequest);
            }
            return ListObjectAttributesPaginator.this.client.listObjectAttributes((ListObjectAttributesRequest)((Object)ListObjectAttributesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

