/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse;

public final class ListDevelopmentSchemaArnsPaginator
implements SdkIterable<ListDevelopmentSchemaArnsResponse> {
    private final CloudDirectoryClient client;
    private final ListDevelopmentSchemaArnsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListDevelopmentSchemaArnsPaginator(CloudDirectoryClient client, ListDevelopmentSchemaArnsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDevelopmentSchemaArnsResponseFetcher();
    }

    public Iterator<ListDevelopmentSchemaArnsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListDevelopmentSchemaArnsResponseFetcher
    implements NextPageFetcher<ListDevelopmentSchemaArnsResponse> {
        private ListDevelopmentSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevelopmentSchemaArnsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDevelopmentSchemaArnsResponse nextPage(ListDevelopmentSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListDevelopmentSchemaArnsPaginator.this.client.listDevelopmentSchemaArns(ListDevelopmentSchemaArnsPaginator.this.firstRequest);
            }
            return ListDevelopmentSchemaArnsPaginator.this.client.listDevelopmentSchemaArns((ListDevelopmentSchemaArnsRequest)((Object)ListDevelopmentSchemaArnsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

