/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.TypedAttributeValueRange;
import software.amazon.awssdk.services.clouddirectory.transform.TypedLinkAttributeRangeMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TypedLinkAttributeRange
implements StructuredPojo,
ToCopyableBuilder<Builder, TypedLinkAttributeRange> {
    private final String attributeName;
    private final TypedAttributeValueRange range;

    private TypedLinkAttributeRange(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.range = builder.range;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public TypedAttributeValueRange range() {
        return this.range;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.range());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkAttributeRange)) {
            return false;
        }
        TypedLinkAttributeRange other = (TypedLinkAttributeRange)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && Objects.equals(this.range(), other.range());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.range() != null) {
            sb.append("Range: ").append(this.range()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
            case "Range": {
                return Optional.of(clazz.cast(this.range()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TypedLinkAttributeRangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private TypedAttributeValueRange range;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkAttributeRange model) {
            this.attributeName(model.attributeName);
            this.range(model.range);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final TypedAttributeValueRange.Builder getRange() {
            return this.range != null ? this.range.toBuilder() : null;
        }

        @Override
        public final Builder range(TypedAttributeValueRange range) {
            this.range = range;
            return this;
        }

        public final void setRange(TypedAttributeValueRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        public TypedLinkAttributeRange build() {
            return new TypedLinkAttributeRange(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TypedLinkAttributeRange> {
        public Builder attributeName(String var1);

        public Builder range(TypedAttributeValueRange var1);

        default public Builder range(Consumer<TypedAttributeValueRange.Builder> range) {
            return this.range((TypedAttributeValueRange)((TypedAttributeValueRange.Builder)TypedAttributeValueRange.builder().apply(range)).build());
        }
    }
}

