/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetObjectInformationResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, GetObjectInformationResponse> {
    private final List<SchemaFacet> schemaFacets;
    private final String objectIdentifier;

    private GetObjectInformationResponse(BuilderImpl builder) {
        super(builder);
        this.schemaFacets = builder.schemaFacets;
        this.objectIdentifier = builder.objectIdentifier;
    }

    public List<SchemaFacet> schemaFacets() {
        return this.schemaFacets;
    }

    public String objectIdentifier() {
        return this.objectIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaFacets());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectInformationResponse)) {
            return false;
        }
        GetObjectInformationResponse other = (GetObjectInformationResponse)((Object)obj);
        return Objects.equals(this.schemaFacets(), other.schemaFacets()) && Objects.equals(this.objectIdentifier(), other.objectIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.schemaFacets() != null) {
            sb.append("SchemaFacets: ").append(this.schemaFacets()).append(",");
        }
        if (this.objectIdentifier() != null) {
            sb.append("ObjectIdentifier: ").append(this.objectIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaFacets": {
                return Optional.of(clazz.cast(this.schemaFacets()));
            }
            case "ObjectIdentifier": {
                return Optional.of(clazz.cast(this.objectIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private List<SchemaFacet> schemaFacets;
        private String objectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectInformationResponse model) {
            this.schemaFacets(model.schemaFacets);
            this.objectIdentifier(model.objectIdentifier);
        }

        public final Collection<SchemaFacet.Builder> getSchemaFacets() {
            return this.schemaFacets != null ? (Collection)this.schemaFacets.stream().map(SchemaFacet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaFacets(Collection<SchemaFacet> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copy(schemaFacets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(SchemaFacet ... schemaFacets) {
            this.schemaFacets(Arrays.asList(schemaFacets));
            return this;
        }

        public final void setSchemaFacets(Collection<SchemaFacet.BuilderImpl> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copyFromBuilder(schemaFacets);
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public GetObjectInformationResponse build() {
            return new GetObjectInformationResponse(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    CopyableBuilder<Builder, GetObjectInformationResponse> {
        public Builder schemaFacets(Collection<SchemaFacet> var1);

        public Builder schemaFacets(SchemaFacet ... var1);

        public Builder objectIdentifier(String var1);
    }
}

