/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacetListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateObjectRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, CreateObjectRequest> {
    private final String directoryArn;
    private final List<SchemaFacet> schemaFacets;
    private final List<AttributeKeyAndValue> objectAttributeList;
    private final ObjectReference parentReference;
    private final String linkName;

    private CreateObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.schemaFacets = builder.schemaFacets;
        this.objectAttributeList = builder.objectAttributeList;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    public String directoryArn() {
        return this.directoryArn;
    }

    public List<SchemaFacet> schemaFacets() {
        return this.schemaFacets;
    }

    public List<AttributeKeyAndValue> objectAttributeList() {
        return this.objectAttributeList;
    }

    public ObjectReference parentReference() {
        return this.parentReference;
    }

    public String linkName() {
        return this.linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaFacets());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectAttributeList());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateObjectRequest)) {
            return false;
        }
        CreateObjectRequest other = (CreateObjectRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.schemaFacets(), other.schemaFacets()) && Objects.equals(this.objectAttributeList(), other.objectAttributeList()) && Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.linkName(), other.linkName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.directoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.directoryArn()).append(",");
        }
        if (this.schemaFacets() != null) {
            sb.append("SchemaFacets: ").append(this.schemaFacets()).append(",");
        }
        if (this.objectAttributeList() != null) {
            sb.append("ObjectAttributeList: ").append(this.objectAttributeList()).append(",");
        }
        if (this.parentReference() != null) {
            sb.append("ParentReference: ").append(this.parentReference()).append(",");
        }
        if (this.linkName() != null) {
            sb.append("LinkName: ").append(this.linkName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.of(clazz.cast(this.directoryArn()));
            }
            case "SchemaFacets": {
                return Optional.of(clazz.cast(this.schemaFacets()));
            }
            case "ObjectAttributeList": {
                return Optional.of(clazz.cast(this.objectAttributeList()));
            }
            case "ParentReference": {
                return Optional.of(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.of(clazz.cast(this.linkName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<SchemaFacet> schemaFacets;
        private List<AttributeKeyAndValue> objectAttributeList;
        private ObjectReference parentReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateObjectRequest model) {
            this.directoryArn(model.directoryArn);
            this.schemaFacets(model.schemaFacets);
            this.objectAttributeList(model.objectAttributeList);
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Collection<SchemaFacet.Builder> getSchemaFacets() {
            return this.schemaFacets != null ? (Collection)this.schemaFacets.stream().map(SchemaFacet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder schemaFacets(Collection<SchemaFacet> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copy(schemaFacets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(SchemaFacet ... schemaFacets) {
            this.schemaFacets(Arrays.asList(schemaFacets));
            return this;
        }

        public final void setSchemaFacets(Collection<SchemaFacet.BuilderImpl> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copyFromBuilder(schemaFacets);
        }

        public final Collection<AttributeKeyAndValue.Builder> getObjectAttributeList() {
            return this.objectAttributeList != null ? (Collection)this.objectAttributeList.stream().map(AttributeKeyAndValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            this.objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue.BuilderImpl> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copyFromBuilder(objectAttributeList);
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateObjectRequest build() {
            return new CreateObjectRequest(this);
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    CopyableBuilder<Builder, CreateObjectRequest> {
        public Builder directoryArn(String var1);

        public Builder schemaFacets(Collection<SchemaFacet> var1);

        public Builder schemaFacets(SchemaFacet ... var1);

        public Builder objectAttributeList(Collection<AttributeKeyAndValue> var1);

        public Builder objectAttributeList(AttributeKeyAndValue ... var1);

        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().apply(parentReference)).build());
        }

        public Builder linkName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

