/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment;

@SdkInternalApi
public class PolicyAttachmentMarshaller {
    private static final MarshallingInfo<String> POLICYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyId").build();
    private static final MarshallingInfo<String> OBJECTIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectIdentifier").build();
    private static final MarshallingInfo<String> POLICYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PolicyType").build();
    private static final PolicyAttachmentMarshaller INSTANCE = new PolicyAttachmentMarshaller();

    public static PolicyAttachmentMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PolicyAttachment policyAttachment, ProtocolMarshaller protocolMarshaller) {
        if (policyAttachment == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)policyAttachment.policyId(), POLICYID_BINDING);
            protocolMarshaller.marshall((Object)policyAttachment.objectIdentifier(), OBJECTIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)policyAttachment.policyType(), POLICYTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

