/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes;

@SdkInternalApi
public class BatchUpdateObjectAttributesMarshaller {
    private static final MarshallingInfo<StructuredPojo> OBJECTREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ObjectReference").build();
    private static final MarshallingInfo<List> ATTRIBUTEUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeUpdates").build();
    private static final BatchUpdateObjectAttributesMarshaller INSTANCE = new BatchUpdateObjectAttributesMarshaller();

    public static BatchUpdateObjectAttributesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchUpdateObjectAttributes batchUpdateObjectAttributes, ProtocolMarshaller protocolMarshaller) {
        if (batchUpdateObjectAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)batchUpdateObjectAttributes.objectReference(), OBJECTREFERENCE_BINDING);
            protocolMarshaller.marshall(batchUpdateObjectAttributes.attributeUpdates(), ATTRIBUTEUPDATES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

